/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.security.csrf.CrumbFilter;
import java.util.Collections;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GitStatusCrumbExclusionTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    private CrumbFilter filter;
    private HttpServletRequest req;
    private HttpServletResponse resp;
    private FilterChain chain;

    @Before
    public void before() {
        this.filter = new CrumbFilter();
        this.req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.chain = (FilterChain)Mockito.mock(FilterChain.class);
    }

    @Test
    public void testNotifyCommit() throws Exception {
        Mockito.when((Object)this.req.getPathInfo()).thenReturn((Object)"/git/notifyCommit");
        Mockito.when((Object)this.req.getMethod()).thenReturn((Object)"POST");
        Mockito.when((Object)this.req.getParameterNames()).thenReturn(Collections.emptyEnumeration());
        this.filter.doFilter((ServletRequest)this.req, (ServletResponse)this.resp, this.chain);
        ((HttpServletResponse)Mockito.verify((Object)this.resp, (VerificationMode)Mockito.never())).sendError(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
    }

    @Test
    public void testInvalidPath() throws Exception {
        Mockito.when((Object)this.req.getPathInfo()).thenReturn((Object)"/git/somethingElse");
        Mockito.when((Object)this.req.getMethod()).thenReturn((Object)"POST");
        Mockito.when((Object)this.req.getParameterNames()).thenReturn(Collections.emptyEnumeration());
        this.filter.doFilter((ServletRequest)this.req, (ServletResponse)this.resp, this.chain);
        ((HttpServletResponse)Mockito.verify((Object)this.resp, (VerificationMode)Mockito.times((int)1))).sendError(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
    }
}

