/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.Cause;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.TestGitRepo;
import hudson.scm.SCM;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.multiplescms.MultiSCM;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.CaptureEnvironmentBuilder;
import org.jvnet.hudson.test.JenkinsRule;

public class MultipleSCMTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    protected TaskListener listener;
    protected TestGitRepo repo0;
    protected TestGitRepo repo1;

    @Before
    public void setUp() throws Exception {
        this.listener = StreamTaskListener.fromStderr();
        this.repo0 = new TestGitRepo("repo0", this.tmp.newFolder(), this.listener);
        this.repo1 = new TestGitRepo("repo1", this.tmp.newFolder(), this.listener);
    }

    @Test
    public void basic() throws Exception {
        FreeStyleProject project = this.setupBasicProject("master");
        this.repo0.commit("repo0-init", this.repo0.johnDoe, "repo0 initial commit");
        Assert.assertTrue((String)"scm polling should detect a change after initial commit", (boolean)project.poll(this.listener).hasChanges());
        this.repo1.commit("repo1-init", this.repo1.janeDoe, "repo1 initial commit");
        this.build(project, Result.SUCCESS);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        this.repo1.commit("repo1-1", this.repo1.johnDoe, "repo1 commit 1");
        this.build(project, Result.SUCCESS);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        this.repo0.commit("repo0-1", this.repo0.janeDoe, "repo0 commit 1");
        this.build(project, Result.SUCCESS);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    private FreeStyleProject setupBasicProject(String name) throws IOException {
        FreeStyleProject project = this.r.createFreeStyleProject(name);
        List<BranchSpec> branch = Collections.singletonList(new BranchSpec("master"));
        GitSCM repo0Scm = new GitSCM(this.repo0.remoteConfigs(), branch, Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        GitSCM repo1Scm = new GitSCM(this.repo1.remoteConfigs(), branch, Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        ArrayList<GitSCM> testScms = new ArrayList<GitSCM>();
        testScms.add(repo0Scm);
        testScms.add(repo1Scm);
        MultiSCM scm = new MultiSCM(testScms);
        project.setScm((SCM)scm);
        project.getBuildersList().add((Object)new CaptureEnvironmentBuilder());
        return project;
    }

    private FreeStyleBuild build(FreeStyleProject project, Result expectedResult) throws Exception {
        FreeStyleBuild build = (FreeStyleBuild)project.scheduleBuild2(0, (Cause)new Cause.UserIdCause()).get();
        if (expectedResult != null) {
            this.r.assertBuildStatus(expectedResult, (Run)build);
        }
        return build;
    }
}

