/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.SubmoduleConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SubmoduleConfigTest {
    private SubmoduleConfig config = new SubmoduleConfig();
    private SubmoduleConfig configWithBranchArray;
    private SubmoduleConfig configWithBranchList;
    private static final String SHA1 = "beaddeedfeedcededeafcadebadeabadedfeedad";
    private static final ObjectId ID = ObjectId.fromString((String)"beaddeedfeedcededeafcadebadeabadedfeedad");
    private static final ObjectId ID2 = ObjectId.fromString((String)"beaddeedfeedcededeafcadebadeabadedfeedad".replace('a', 'e'));
    private final String[] branchNames = new String[]{"master", "comma,chameleon", "develop"};
    private final Revision emptyRevision;
    private final Revision noBranchesRevision;
    private final Revision multipleBranchesRevision;
    private final Branch masterBranch;
    private final Branch masterAliasBranch;
    private final Branch developBranch;
    private final List<String> branchNameList = new ArrayList<String>();

    public SubmoduleConfigTest() {
        ArrayList emptyBranchList = new ArrayList();
        this.emptyRevision = new Revision(ID, emptyBranchList);
        this.masterBranch = new Branch("master", ID);
        this.masterAliasBranch = new Branch("masterAlias", ID);
        this.developBranch = new Branch("develop", ID2);
        ArrayList<Branch> branchList = new ArrayList<Branch>();
        branchList.add(this.masterBranch);
        branchList.add(this.masterAliasBranch);
        branchList.add(this.developBranch);
        this.noBranchesRevision = new Revision(ID);
        this.multipleBranchesRevision = new Revision(ID, branchList);
        this.branchNameList.add("master");
        this.branchNameList.add("masterAlias");
        this.branchNameList.add("develop");
    }

    @Before
    public void setUp() {
        this.config = new SubmoduleConfig();
        this.configWithBranchArray = new SubmoduleConfig("submodule-branch-names-from-array", this.branchNames);
        this.configWithBranchList = new SubmoduleConfig("submodule-branch-names-from-list", this.branchNameList);
    }

    @Test
    public void testGetSubmoduleName() {
        Assert.assertThat((Object)this.config.getSubmoduleName(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSetSubmoduleName() {
        String name = "name-of-submodule";
        this.config.setSubmoduleName(name);
        Assert.assertThat((Object)this.config.getSubmoduleName(), (Matcher)Matchers.is((Object)name));
        name = "another-submodule";
        this.config.setSubmoduleName(name);
        Assert.assertThat((Object)this.config.getSubmoduleName(), (Matcher)Matchers.is((Object)name));
    }

    @Test(expected=NullPointerException.class)
    public void testGetBranches() {
        this.config.getBranches();
    }

    public void testGetBranchesFromArray() {
        Assert.assertThat((Object)this.configWithBranchArray.getBranches(), (Matcher)Matchers.is((Object)this.branchNames));
    }

    public void testGetBranchesFromList() {
        Assert.assertThat((Object)this.configWithBranchList.getBranches(), (Matcher)Matchers.is((Object)this.branchNames));
    }

    @Test
    public void testSetBranches() {
        this.config.setBranches(this.branchNames);
        Assert.assertThat((Object)this.config.getBranches(), (Matcher)Matchers.is((Object)this.branchNames));
        String[] newBranchNames = Arrays.copyOf(this.branchNames, this.branchNames.length);
        newBranchNames[0] = "new-master";
        this.config.setBranches(newBranchNames);
        Assert.assertThat((Object)this.config.getBranches(), (Matcher)Matchers.is((Object)newBranchNames));
    }

    @Test(expected=NullPointerException.class)
    public void testGetBranchesStringNPE() {
        this.config.getBranchesString();
    }

    @Test
    public void testGetBranchesString() {
        this.config.setBranches(this.branchNames);
        Assert.assertThat((Object)this.config.getBranchesString(), (Matcher)Matchers.is((Object)"master,comma,chameleon,develop"));
    }

    @Test
    public void testGetBranchesStringFromList() {
        Assert.assertThat((Object)this.configWithBranchList.getBranchesString(), (Matcher)Matchers.is((Object)"master,masterAlias,develop"));
        this.configWithBranchList.setBranches(this.branchNames);
        Assert.assertThat((Object)this.configWithBranchList.getBranchesString(), (Matcher)Matchers.is((Object)"master,comma,chameleon,develop"));
    }

    @Test
    public void testGetBranchesStringFromArray() {
        Assert.assertThat((Object)this.configWithBranchArray.getBranchesString(), (Matcher)Matchers.is((Object)"master,comma,chameleon,develop"));
        this.configWithBranchArray.setBranches(this.branchNames);
        Assert.assertThat((Object)this.configWithBranchArray.getBranchesString(), (Matcher)Matchers.is((Object)"master,comma,chameleon,develop"));
    }

    @Test
    public void testRevisionMatchesInterestNoBranches() {
        Assert.assertFalse((boolean)this.config.revisionMatchesInterest(this.noBranchesRevision));
        Assert.assertFalse((boolean)this.configWithBranchList.revisionMatchesInterest(this.noBranchesRevision));
        Assert.assertFalse((boolean)this.configWithBranchArray.revisionMatchesInterest(this.noBranchesRevision));
    }

    @Test
    public void testRevisionMatchesInterestEmptyBranchList() {
        Assert.assertFalse((boolean)this.config.revisionMatchesInterest(this.emptyRevision));
        Assert.assertFalse((boolean)this.configWithBranchList.revisionMatchesInterest(this.emptyRevision));
        Assert.assertFalse((boolean)this.configWithBranchArray.revisionMatchesInterest(this.emptyRevision));
    }

    @Test(expected=NullPointerException.class)
    public void testRevisionMatchesInterestNPE() {
        this.config.revisionMatchesInterest(this.multipleBranchesRevision);
    }

    @Test
    public void testRevisionMatchesInterestMasterOnly() {
        String[] masterOnly = new String[]{"master"};
        this.config.setBranches(masterOnly);
        Assert.assertTrue((boolean)this.config.revisionMatchesInterest(this.multipleBranchesRevision));
        Assert.assertFalse((boolean)this.configWithBranchList.revisionMatchesInterest(this.multipleBranchesRevision));
        this.configWithBranchList.setBranches(masterOnly);
        Assert.assertTrue((boolean)this.configWithBranchList.revisionMatchesInterest(this.multipleBranchesRevision));
        Assert.assertFalse((boolean)this.configWithBranchArray.revisionMatchesInterest(this.multipleBranchesRevision));
        this.configWithBranchArray.setBranches(masterOnly);
        Assert.assertTrue((boolean)this.configWithBranchArray.revisionMatchesInterest(this.multipleBranchesRevision));
    }

    @Test
    public void testRevisionMatchesInterestAlias() {
        String[] aliasName = new String[]{"masterAlias"};
        this.config.setBranches(aliasName);
        Assert.assertTrue((boolean)this.config.revisionMatchesInterest(this.multipleBranchesRevision));
        Assert.assertFalse((boolean)this.configWithBranchList.revisionMatchesInterest(this.multipleBranchesRevision));
        this.configWithBranchList.setBranches(aliasName);
        Assert.assertTrue((boolean)this.configWithBranchList.revisionMatchesInterest(this.multipleBranchesRevision));
        Assert.assertFalse((boolean)this.configWithBranchArray.revisionMatchesInterest(this.multipleBranchesRevision));
        this.configWithBranchArray.setBranches(aliasName);
        Assert.assertTrue((boolean)this.configWithBranchArray.revisionMatchesInterest(this.multipleBranchesRevision));
    }

    @Test
    public void testRevisionMatchesInterest() {
        String[] masterDevelop = new String[]{"master", "develop"};
        this.config.setBranches(masterDevelop);
        Assert.assertFalse((boolean)this.config.revisionMatchesInterest(this.multipleBranchesRevision));
        Assert.assertFalse((boolean)this.configWithBranchList.revisionMatchesInterest(this.multipleBranchesRevision));
        Assert.assertFalse((boolean)this.configWithBranchArray.revisionMatchesInterest(this.multipleBranchesRevision));
    }

    @Test
    public void testBranchMatchesInterest() {
        String[] masterOnly = new String[]{"master"};
        this.config.setBranches(masterOnly);
        Assert.assertTrue((boolean)this.config.branchMatchesInterest(this.masterBranch));
        Assert.assertFalse((boolean)this.config.branchMatchesInterest(this.masterAliasBranch));
        Assert.assertFalse((boolean)this.config.branchMatchesInterest(this.developBranch));
        Assert.assertFalse((boolean)this.configWithBranchList.branchMatchesInterest(this.masterBranch));
        Assert.assertFalse((boolean)this.configWithBranchList.branchMatchesInterest(this.masterAliasBranch));
        Assert.assertFalse((boolean)this.configWithBranchList.branchMatchesInterest(this.developBranch));
        this.configWithBranchList.setBranches(masterOnly);
        Assert.assertTrue((boolean)this.configWithBranchList.branchMatchesInterest(this.masterBranch));
        Assert.assertFalse((boolean)this.configWithBranchList.branchMatchesInterest(this.masterAliasBranch));
        Assert.assertFalse((boolean)this.configWithBranchList.branchMatchesInterest(this.developBranch));
    }

    @Test
    public void testBranchMatchesInterestWithRegex() {
        String[] masterOnlyRegex = new String[]{"m.st.r"};
        this.config.setBranches(masterOnlyRegex);
        Assert.assertTrue((boolean)this.config.branchMatchesInterest(this.masterBranch));
        Assert.assertFalse((boolean)this.config.branchMatchesInterest(this.masterAliasBranch));
        Assert.assertFalse((boolean)this.config.branchMatchesInterest(this.developBranch));
    }

    @Test
    public void testBranchMatchesInterestMasterDevelop() {
        String[] masterDevelop = new String[]{"master", "develop"};
        this.config.setBranches(masterDevelop);
        Assert.assertFalse((boolean)this.config.branchMatchesInterest(this.masterBranch));
        Assert.assertFalse((boolean)this.config.branchMatchesInterest(this.masterAliasBranch));
        Assert.assertFalse((boolean)this.config.branchMatchesInterest(this.developBranch));
    }

    @Test
    public void testBranchMatchesInterestCommaInBranchName() {
        this.config.setBranches(this.branchNames);
        Assert.assertFalse((boolean)this.config.branchMatchesInterest(this.masterBranch));
        Assert.assertFalse((boolean)this.config.branchMatchesInterest(this.masterAliasBranch));
        Assert.assertFalse((boolean)this.config.branchMatchesInterest(this.developBranch));
    }
}

