/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.CGit;
import hudson.plugins.git.browser.GitChangeSetSample;
import hudson.scm.EditType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CGitTest {
    private final String repoUrl = "http://cgit.example.com/";
    private final boolean useAuthorName;
    private final GitChangeSetSample sample;

    public CGitTest(String useAuthorName) {
        this.useAuthorName = Boolean.valueOf(useAuthorName);
        this.sample = new GitChangeSetSample(this.useAuthorName);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection permuteAuthorName() {
        String[] allowed;
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (String authorName : allowed = new String[]{"true", "false"}) {
            Object[] combination = new Object[]{authorName};
            values.add(combination);
        }
        return values;
    }

    @Test
    public void testGetChangeSetLink() throws Exception {
        URL result = new CGit("http://cgit.example.com/").getChangeSetLink(this.sample.changeSet);
        Assert.assertEquals((Object)new URL("http://cgit.example.com/commit/?id=" + this.sample.id), (Object)result);
    }

    @Test
    public void testGetDiffLink() throws Exception {
        CGit cgit = new CGit("http://cgit.example.com/");
        for (GitChangeSet.Path path : this.sample.changeSet.getPaths()) {
            URL diffLink = cgit.getDiffLink(path);
            EditType editType = path.getEditType();
            URL expectedDiffLink = null;
            if (editType == EditType.ADD || editType == EditType.EDIT) {
                expectedDiffLink = new URL("http://cgit.example.com/diff/" + path.getPath() + "?id=" + this.sample.id);
            } else if (editType == EditType.DELETE) {
                expectedDiffLink = new URL("http://cgit.example.com/diff/" + path.getPath() + "?id=" + this.sample.id);
            } else {
                Assert.fail((String)("Unexpected edit type " + editType.getName()));
            }
            String msg = "Wrong link for path: " + path.getPath() + ", edit type: " + editType.getName();
            Assert.assertEquals((String)msg, (Object)expectedDiffLink, (Object)diffLink);
        }
    }

    @Test
    public void testGetFileLink() throws Exception {
        CGit cgit = new CGit("http://cgit.example.com/");
        for (GitChangeSet.Path path : this.sample.changeSet.getPaths()) {
            URL fileLink = cgit.getFileLink(path);
            EditType editType = path.getEditType();
            URL expectedFileLink = null;
            if (editType == EditType.ADD || editType == EditType.EDIT) {
                expectedFileLink = new URL("http://cgit.example.com/tree/" + path.getPath() + "?id=" + this.sample.id);
            } else if (editType == EditType.DELETE) {
                expectedFileLink = new URL("http://cgit.example.com/tree/" + path.getPath() + "?id=" + this.sample.parent);
            } else {
                Assert.fail((String)("Unexpected edit type " + editType.getName()));
            }
            String msg = "Wrong link for path: " + path.getPath() + ", edit type: " + editType.getName();
            Assert.assertEquals((String)msg, (Object)expectedFileLink, (Object)fileLink);
        }
    }
}

