/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.browser.GithubWeb;
import hudson.scm.RepositoryBrowser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMHead;
import org.eclipse.jgit.transport.RefSpec;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Test;

public class GithubWebTest {
    private static final String GITHUB_URL = "http://github.com/USER/REPO";
    private final GithubWeb githubWeb = new GithubWeb("http://github.com/USER/REPO");
    private final Random random = new Random();

    @Test
    public void testGetUrl() throws IOException {
        Assert.assertEquals((Object)String.valueOf(this.githubWeb.getUrl()), (Object)"http://github.com/USER/REPO/");
    }

    @Test
    public void testGetUrlForRepoWithTrailingSlash() throws IOException {
        Assert.assertEquals((Object)String.valueOf(new GithubWeb("http://github.com/USER/REPO/").getUrl()), (Object)"http://github.com/USER/REPO/");
    }

    @Test
    public void testGetChangeSetLinkGitChangeSet() throws Exception {
        URL changeSetLink = this.githubWeb.getChangeSetLink(this.createChangeSet("rawchangelog"));
        Assert.assertEquals((Object)"http://github.com/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)changeSetLink.toString());
    }

    @Test
    public void testGetDiffLinkPath() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog");
        GitChangeSet.Path path1 = pathMap.get("src/main/java/hudson/plugins/git/browser/GithubWeb.java");
        Assert.assertEquals((Object)"http://github.com/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#diff-0", (Object)this.githubWeb.getDiffLink(path1).toString());
        GitChangeSet.Path path2 = pathMap.get("src/test/java/hudson/plugins/git/browser/GithubWebTest.java");
        Assert.assertEquals((Object)"http://github.com/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#diff-1", (Object)this.githubWeb.getDiffLink(path2).toString());
        GitChangeSet.Path path3 = pathMap.get("src/test/resources/hudson/plugins/git/browser/rawchangelog-with-deleted-file");
        Assert.assertNull((String)"Do not return a diff link for added files.", (Object)this.githubWeb.getDiffLink(path3));
    }

    @Test
    public void testGetFileLinkPath() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog");
        GitChangeSet.Path path = pathMap.get("src/main/java/hudson/plugins/git/browser/GithubWeb.java");
        URL fileLink = this.githubWeb.getFileLink(path);
        Assert.assertEquals((Object)"http://github.com/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)String.valueOf(fileLink));
    }

    @Test
    public void testGetFileLinkPathWithEscape() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog-with-escape");
        GitChangeSet.Path path = pathMap.get("src/test/java/hudson/plugins/git/browser/conf%.txt");
        URL fileLink = this.githubWeb.getFileLink(path);
        Assert.assertEquals((Object)"http://github.com/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/test/java/hudson/plugins/git/browser/conf%25.txt", (Object)String.valueOf(fileLink));
    }

    @Test
    public void testGetFileLinkPathWithWindowsUnescapeChar() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog-with-escape");
        GitChangeSet.Path path = pathMap.get("src/test/java/hudson/plugins/git/browser/conf^%.txt");
        URL fileLink = this.githubWeb.getFileLink(path);
        Assert.assertEquals((Object)"http://github.com/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/test/java/hudson/plugins/git/browser/conf%5E%25.txt", (Object)String.valueOf(fileLink));
    }

    @Test
    public void testGetFileLinkPathWithDoubleEscape() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog-with-escape");
        GitChangeSet.Path path = pathMap.get("src/test/java/hudson/plugins/git/browser/conf%%.txt");
        URL fileLink = this.githubWeb.getFileLink(path);
        Assert.assertEquals((Object)"http://github.com/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/test/java/hudson/plugins/git/browser/conf%25%25.txt", (Object)String.valueOf(fileLink));
    }

    @Test
    public void testGetFileLinkPathWithWindowsEnvironmentalVariable() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog-with-escape");
        GitChangeSet.Path path = pathMap.get("src/test/java/hudson/plugins/git/browser/conf%abc%.txt");
        URL fileLink = this.githubWeb.getFileLink(path);
        Assert.assertEquals((Object)"http://github.com/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/test/java/hudson/plugins/git/browser/conf%25abc%25.txt", (Object)String.valueOf(fileLink));
    }

    @Test
    public void testGetFileLinkPathWithSpaceInName() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog-with-escape");
        GitChangeSet.Path path = pathMap.get("src/test/java/hudson/plugins/git/browser/config file.txt");
        URL fileLink = this.githubWeb.getFileLink(path);
        Assert.assertEquals((Object)"http://github.com/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/test/java/hudson/plugins/git/browser/config%20file.txt", (Object)String.valueOf(fileLink));
    }

    @Test
    public void testGetFileLinkPathForDeletedFile() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog-with-deleted-file");
        GitChangeSet.Path path = pathMap.get("bar");
        URL fileLink = this.githubWeb.getFileLink(path);
        Assert.assertEquals((Object)"http://github.com/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#diff-0", (Object)String.valueOf(fileLink));
    }

    private String repoUrl(String baseUrl, boolean add_git_suffix, boolean add_slash_suffix) {
        return baseUrl + (add_git_suffix ? ".git" : "") + (add_slash_suffix ? "/" : "");
    }

    @Test
    public void testGuessBrowser() {
        boolean[] allowed;
        this.assertGuessURL("https://github.com/kohsuke/msv.git", "https://github.com/kohsuke/msv/");
        this.assertGuessURL("https://github.com/kohsuke/msv/", "https://github.com/kohsuke/msv/");
        this.assertGuessURL("https://github.com/kohsuke/msv", "https://github.com/kohsuke/msv/");
        this.assertGuessURL("git@github.com:kohsuke/msv.git", "https://github.com/kohsuke/msv/");
        this.assertGuessURL("git@git.apache.org:whatever.git", null);
        for (boolean add_git_suffix : allowed = new boolean[]{Boolean.TRUE, Boolean.FALSE}) {
            for (boolean add_slash_suffix : allowed) {
                this.assertGuessURL(this.repoUrl("git@github.com:kohsuke/msv", add_git_suffix, add_slash_suffix), "https://github.com/kohsuke/msv/");
                this.assertGuessURL(this.repoUrl("https://github.com/kohsuke/msv", add_git_suffix, add_slash_suffix), "https://github.com/kohsuke/msv/");
                this.assertGuessURL(this.repoUrl("ssh://github.com/kohsuke/msv", add_git_suffix, add_slash_suffix), "https://github.com/kohsuke/msv/");
                this.assertGuessURL(this.repoUrl("ssh://git@github.com/kohsuke/msv", add_git_suffix, add_slash_suffix), "https://github.com/kohsuke/msv/");
            }
        }
    }

    private void assertGuessURL(String repo, String web) {
        RepositoryBrowser guess = new GitSCM(repo).guessBrowser();
        String actual = guess instanceof GithubWeb ? ((GithubWeb)guess).getRepoUrl() : null;
        Assert.assertEquals((String)("For repo '" + repo + "':"), (Object)web, (Object)actual);
    }

    @Test
    public void guessBrowserSCMSource() throws Exception {
        this.assertGuessURL("https://github.com/kohsuke/msv.git", "https://github.com/kohsuke/msv/", "+refs/heads/*:refs/remotes/origin/*");
        this.assertGuessURL("https://github.com/kohsuke/msv.git", "https://github.com/kohsuke/msv/", "+refs/heads/*:refs/remotes/origin/*", "+refs/pull/*/merge:refs/remotes/origin/pr/*");
    }

    private void assertGuessURL(String remote, String web, String ... refSpecs) {
        RepositoryBrowser guess = new MockSCMSource(remote, refSpecs).build(new SCMHead("master")).guessBrowser();
        String actual = guess instanceof GithubWeb ? ((GithubWeb)guess).getRepoUrl() : null;
        Assert.assertEquals((Object)web, (Object)actual);
    }

    private GitChangeSet createChangeSet(String rawchangelogpath) throws Exception {
        GitClient gitClient = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(new File(".")).using(this.random.nextBoolean() ? null : "jgit").getClient();
        GitChangeLogParser logParser = new GitChangeLogParser(gitClient, false);
        List changeSetList = logParser.parse(GithubWebTest.class.getResourceAsStream(rawchangelogpath));
        return (GitChangeSet)changeSetList.get(0);
    }

    private HashMap<String, GitChangeSet.Path> createPathMap(String changelog) throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = new HashMap<String, GitChangeSet.Path>();
        Collection changeSet = this.createChangeSet(changelog).getPaths();
        for (GitChangeSet.Path path : changeSet) {
            pathMap.put(path.getPath(), path);
        }
        return pathMap;
    }

    private static class MockSCMSource
    extends AbstractGitSCMSource {
        private final String remote;
        private final String[] refSpecs;

        MockSCMSource(String remote, String[] refSpecs) {
            this.remote = remote;
            this.refSpecs = refSpecs;
        }

        public String getCredentialsId() {
            return null;
        }

        public String getRemote() {
            return this.remote;
        }

        public String getIncludes() {
            return "*";
        }

        public String getExcludes() {
            return "";
        }

        protected List<RefSpec> getRefSpecs() {
            ArrayList<RefSpec> result = new ArrayList<RefSpec>();
            for (String refSpec : this.refSpecs) {
                result.add(new RefSpec(refSpec));
            }
            return result;
        }
    }
}

