/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.AbstractGitTestCase;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.impl.BuildSingleRevisionOnly;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class BuildSingleRevisionOnlyTest
extends AbstractGitTestCase {
    @Test
    public void testSingleRevision() throws Exception {
        ArrayList<BranchSpec> branchSpec = new ArrayList<BranchSpec>();
        branchSpec.add(new BranchSpec("master"));
        branchSpec.add(new BranchSpec("foo"));
        branchSpec.add(new BranchSpec("bar"));
        FreeStyleProject project = this.setupProject(branchSpec, false, "", "", "", "", false, "");
        ((GitSCM)project.getScm()).getExtensions().add((Object)new BuildSingleRevisionOnly());
        String commitFile = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Initial commit in master");
        this.git.branch("foo");
        this.git.branch("bar");
        this.git.checkoutBranch("foo", "master");
        this.commit("commitFile1", this.johnDoe, "Commit in foo");
        this.git.checkoutBranch("bar", "master");
        this.commit("commitFile1", this.johnDoe, "Commit in bar");
        FreeStyleBuild build = this.build(project, Result.SUCCESS, "commitFile1");
        this.rule.assertBuildStatusSuccess((Run)build);
        boolean result = build.getLog(100).contains(String.format("Scheduling another build to catch up with %s", project.getName()));
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testMultiRevision() throws Exception {
        ArrayList<BranchSpec> branchSpec = new ArrayList<BranchSpec>();
        branchSpec.add(new BranchSpec("master"));
        branchSpec.add(new BranchSpec("foo"));
        branchSpec.add(new BranchSpec("bar"));
        FreeStyleProject project = this.setupProject(branchSpec, false, "", "", "", "", false, "");
        String commitFile = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Initial commit in master");
        this.git.branch("foo");
        this.git.branch("bar");
        this.git.checkoutBranch("foo", "master");
        this.commit("commitFile1", this.johnDoe, "Commit in foo");
        this.git.checkoutBranch("bar", "master");
        this.commit("commitFile1", this.johnDoe, "Commit in bar");
        FreeStyleBuild build = this.build(project, Result.SUCCESS, "commitFile1");
        this.rule.assertBuildStatusSuccess((Run)build);
        boolean result = build.getLog(100).contains(String.format("Scheduling another build to catch up with %s", project.getName()));
        Assert.assertTrue((boolean)result);
    }
}

