/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.model.FreeStyleProject;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.TestGitRepo;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionTest;
import hudson.plugins.git.extensions.impl.PathRestriction;
import hudson.plugins.git.util.BuildData;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=Enclosed.class)
public class PathRestrictionTest {

    public static class MultiIncludeTest
    extends PathRestrictionExtensionTest {
        @Override
        protected GitSCMExtension getExtension() {
            return new PathRestriction("foo.*\nqux.*", null);
        }

        @Test
        public void testAccept() throws Exception {
            FakePathGitChangeSet commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("foo/foo.txt", "something/else")));
            Assert.assertNull((Object)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
            commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("foo/foo.txt", "foo.foo", "README.mdown")));
            Assert.assertNull((Object)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
            commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("docs.txt", "qux/more-docs.txt")));
            Assert.assertNull((Object)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
        }

        @Test
        public void testReject() throws Exception {
            FakePathGitChangeSet commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("bar/bar.txt")));
            Assert.assertTrue((boolean)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
            commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("bar/bar.txt", "bar.bar", "README.mdown")));
            Assert.assertTrue((boolean)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
            commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("docs.txt", "more-docs.txt")));
            Assert.assertTrue((boolean)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
            commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("a/really/long/path/file.txt")));
            Assert.assertTrue((boolean)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
        }
    }

    public static class MultiExcludeTest
    extends PathRestrictionExtensionTest {
        @Override
        protected GitSCMExtension getExtension() {
            return new PathRestriction(null, "bar.*\n.*bax");
        }

        @Test
        public void testAccept() throws Exception {
            FakePathGitChangeSet commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("foo/foo.txt")));
            Assert.assertNull((Object)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
            commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("foo/foo.txt", "foo.foo", "README.mdown")));
            Assert.assertNull((Object)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
            commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("docs.txt", "more-docs.txt")));
            Assert.assertNull((Object)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
            commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("a/really/long/path/file.txt")));
            Assert.assertNull((Object)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
        }

        @Test
        public void testReject() throws Exception {
            FakePathGitChangeSet commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("bar/bar.txt", "foo.bax")));
            Assert.assertTrue((boolean)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
            commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("bar/docs.txt", "bar/more-docs.txt")));
            Assert.assertTrue((boolean)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
        }
    }

    public static class BasicIncludeTest
    extends PathRestrictionExtensionTest {
        @Override
        protected GitSCMExtension getExtension() {
            return new PathRestriction("foo.*", null);
        }

        @Test
        public void testMatch() throws Exception {
            FakePathGitChangeSet commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("foo/foo.txt")));
            Assert.assertNull((Object)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
        }

        @Test
        public void testMiss() throws Exception {
            FakePathGitChangeSet commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("bar/bar.txt")));
            Assert.assertTrue((boolean)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
        }
    }

    public static class BasicExcludeTest
    extends PathRestrictionExtensionTest {
        @Override
        protected GitSCMExtension getExtension() {
            return new PathRestriction(null, "bar.*");
        }

        @Test
        public void testMiss() throws Exception {
            FakePathGitChangeSet commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("foo/foo.txt")));
            Assert.assertNull((Object)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
        }

        @Test
        public void testMatch() throws Exception {
            FakePathGitChangeSet commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("bar/bar.txt")));
            Assert.assertTrue((boolean)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
        }
    }

    public static class EmptyPathsTest
    extends PathRestrictionExtensionTest {
        @Override
        protected GitSCMExtension getExtension() {
            return new PathRestriction(".*", null);
        }

        @Test
        public void test() throws Exception {
            FakePathGitChangeSet commit = new FakePathGitChangeSet(new HashSet<String>());
            Assert.assertNull((Object)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
        }
    }

    public static class NoRulesTest
    extends PathRestrictionExtensionTest {
        @Override
        protected GitSCMExtension getExtension() {
            return new PathRestriction(null, null);
        }

        @Test
        public void test() throws Exception {
            FakePathGitChangeSet commit = new FakePathGitChangeSet(new HashSet<String>(Arrays.asList("foo/foo.txt", "bar/bar.txt")));
            Assert.assertNull((Object)this.getExtension().isRevExcluded((GitSCM)this.project.getScm(), this.repo.git, (GitChangeSet)commit, this.listener, this.mockBuildData));
        }
    }

    public static abstract class PathRestrictionExtensionTest
    extends GitSCMExtensionTest {
        protected FreeStyleProject project;
        protected TestGitRepo repo;
        protected BuildData mockBuildData = (BuildData)Mockito.mock(BuildData.class);

        @Override
        public void before() throws Exception {
            this.repo = new TestGitRepo("repo", this.tmp.newFolder(), this.listener);
            this.project = this.setupBasicProject(this.repo);
        }
    }

    @Ignore(value="Not a test")
    public static class FakePathGitChangeSet
    extends GitChangeSet {
        private Collection<String> paths;

        public FakePathGitChangeSet(Collection<String> paths) {
            super(Collections.emptyList(), false);
            this.paths = paths;
        }

        public Collection<String> getAffectedPaths() {
            return this.paths;
        }

        public String getCommitId() {
            return "fake123";
        }
    }
}

