/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.impl.SubmoduleOption;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import java.io.IOException;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SubmoduleOptionTest {
    @Test
    public void testSubmoduleUpdateThrowsIOException() throws Exception {
        SubmoduleOption submoduleOption = new SubmoduleOption(false, false, false, null, null, false);
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Build lastBuild = (Build)Mockito.mock(Build.class);
        GitSCM scm = (GitSCM)Mockito.mock(GitSCM.class);
        Run build = (Run)Mockito.mock(Run.class);
        GitClient client = (GitClient)Mockito.mock(GitClient.class);
        TaskListener listener = (TaskListener)Mockito.mock(TaskListener.class);
        buildData.lastBuild = lastBuild;
        Mockito.when((Object)scm.getBuildData(build)).thenReturn((Object)buildData);
        Mockito.when((Object)client.hasGitModules()).thenReturn((Object)true);
        Mockito.when((Object)client.submoduleUpdate()).thenThrow(new Throwable[]{new GitException("a git exception")});
        try {
            submoduleOption.onCheckoutCompleted(scm, build, client, listener);
            Assert.fail((String)"Expected IOException to be thrown");
        }
        catch (IOException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Could not perform submodule update"));
        }
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(SubmoduleOption.class).usingGetClass().suppress(new Warning[]{Warning.NONFINAL_FIELDS}).verify();
    }
}

