/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.EnvVars;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.git.TestGitRepo;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionTest;
import hudson.plugins.git.extensions.impl.WipeWorkspace;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Test;
import org.jvnet.hudson.test.WithoutJenkins;

public class WipeWorkspaceTest
extends GitSCMExtensionTest {
    TestGitRepo repo;
    GitClient git;

    @Override
    public void before() throws Exception {
    }

    @Override
    protected GitSCMExtension getExtension() {
        return new WipeWorkspace();
    }

    @Test
    public void testWipeWorkspace() throws Exception {
        this.repo = new TestGitRepo("repo", this.tmp.newFolder(), this.listener);
        this.git = Git.with((TaskListener)this.listener, (EnvVars)new EnvVars()).in(this.repo.gitDir).getClient();
        FreeStyleProject projectWithMaster = this.setupBasicProject(this.repo);
        this.git.commit("First commit");
        FreeStyleBuild build = this.build(projectWithMaster, Result.SUCCESS);
        String buildLog = build.getLog();
        MatcherAssert.assertThat((String)"Workspace not cleaned before checkout", (Object)true, (Matcher)Matchers.is((Object)buildLog.contains("Wiping out workspace first.")));
    }

    @Test
    @WithoutJenkins
    public void equalsContract() {
        EqualsVerifier.forClass(WipeWorkspace.class).usingGetClass().verify();
    }
}

