/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.model.Api;
import hudson.model.Result;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import java.util.ArrayList;
import java.util.Random;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.eclipse.jgit.lib.ObjectId;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BuildDataTest {
    private BuildData data;
    private final ObjectId sha1 = ObjectId.fromString((String)"929e92e3adaff2e6e1d752a8168c1598890fe84c");
    private final String remoteUrl = "https://github.com/jenkinsci/git-plugin";

    @Before
    public void setUp() throws Exception {
        this.data = new BuildData();
    }

    @Test
    public void testGetDisplayName() throws Exception {
        Assert.assertThat((Object)this.data.getDisplayName(), (Matcher)Matchers.is((Object)"Git Build Data"));
    }

    @Test
    public void testGetDisplayNameEmptyString() throws Exception {
        String scmName = "";
        BuildData dataWithSCM = new BuildData(scmName);
        Assert.assertThat((Object)dataWithSCM.getDisplayName(), (Matcher)Matchers.is((Object)"Git Build Data"));
    }

    @Test
    public void testGetDisplayNameNullSCMName() throws Exception {
        BuildData dataWithNullSCM = new BuildData(null);
        Assert.assertThat((Object)dataWithNullSCM.getDisplayName(), (Matcher)Matchers.is((Object)"Git Build Data"));
    }

    @Test
    public void testGetDisplayNameWithSCM() throws Exception {
        String scmName = "testSCM";
        BuildData dataWithSCM = new BuildData("testSCM");
        Assert.assertThat((Object)"Git Build Data:testSCM", (Matcher)Matchers.is((Object)dataWithSCM.getDisplayName()));
    }

    @Test
    public void testGetIconFileName() {
        Assert.assertThat((Object)this.data.getIconFileName(), (Matcher)Matchers.endsWith((String)"/plugin/git/icons/git-32x32.png"));
    }

    @Test
    public void testGetUrlName() {
        Assert.assertThat((Object)this.data.getUrlName(), (Matcher)Matchers.is((Object)"git"));
    }

    @Test
    public void testGetUrlNameMultipleEntries() {
        Random random = new Random();
        int randomIndex = random.nextInt(1234) + 1;
        this.data.setIndex(Integer.valueOf(randomIndex));
        Assert.assertThat((Object)this.data.getUrlName(), (Matcher)Matchers.is((Object)("git-" + randomIndex)));
    }

    @Test
    public void testHasBeenBuilt() {
        Assert.assertFalse((boolean)this.data.hasBeenBuilt(this.sha1));
    }

    @Test
    public void testGetLastBuild() {
        Assert.assertEquals(null, (Object)this.data.getLastBuild(this.sha1));
    }

    @Test
    public void testSaveBuild() {
        Revision revision = new Revision(this.sha1);
        Build build = new Build(revision, 1, Result.SUCCESS);
        this.data.saveBuild(build);
        Assert.assertThat((Object)this.data.getLastBuild(this.sha1), (Matcher)Matchers.is((Object)build));
    }

    @Test
    public void testGetLastBuildOfBranch() {
        String branchName = "origin/master";
        Assert.assertEquals(null, (Object)this.data.getLastBuildOfBranch(branchName));
        ArrayList<Branch> branches = new ArrayList<Branch>();
        Branch branch = new Branch(branchName, this.sha1);
        branches.add(branch);
        Revision revision = new Revision(this.sha1, branches);
        Build build = new Build(revision, 13, Result.FAILURE);
        this.data.saveBuild(build);
        Assert.assertThat((Object)this.data.getLastBuildOfBranch(branchName), (Matcher)Matchers.is((Object)build));
    }

    @Test
    public void testGetLastBuiltRevision() {
        Revision revision = new Revision(this.sha1);
        Build build = new Build(revision, 1, Result.SUCCESS);
        this.data.saveBuild(build);
        Assert.assertThat((Object)this.data.getLastBuiltRevision(), (Matcher)Matchers.is((Object)revision));
    }

    @Test
    public void testGetBuildsByBranchName() {
        Assert.assertTrue((boolean)this.data.getBuildsByBranchName().isEmpty());
    }

    @Test
    public void testGetScmName() {
        Assert.assertThat((Object)this.data.getScmName(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void testSetScmName() {
        String scmName = "Some SCM name";
        this.data.setScmName("Some SCM name");
        Assert.assertThat((Object)this.data.getScmName(), (Matcher)Matchers.is((Object)"Some SCM name"));
    }

    @Test
    public void testAddRemoteUrl() {
        this.data.addRemoteUrl("https://github.com/jenkinsci/git-plugin");
        Assert.assertEquals((long)1L, (long)this.data.getRemoteUrls().size());
        String remoteUrl2 = "https://github.com/jenkinsci/git-plugin.git/";
        this.data.addRemoteUrl(remoteUrl2);
        Assert.assertFalse((boolean)this.data.getRemoteUrls().isEmpty());
        Assert.assertTrue((String)"Second URL not found in remote URLs", (boolean)this.data.getRemoteUrls().contains(remoteUrl2));
        Assert.assertEquals((long)2L, (long)this.data.getRemoteUrls().size());
    }

    @Test
    public void testHasBeenReferenced() {
        Assert.assertFalse((boolean)this.data.hasBeenReferenced("https://github.com/jenkinsci/git-plugin"));
        this.data.addRemoteUrl("https://github.com/jenkinsci/git-plugin");
        Assert.assertTrue((boolean)this.data.hasBeenReferenced("https://github.com/jenkinsci/git-plugin"));
        Assert.assertFalse((boolean)this.data.hasBeenReferenced("https://github.com/jenkinsci/git-plugin/"));
    }

    @Test
    public void testGetApi() {
        Api api = this.data.getApi();
        Api apiClone = this.data.clone().getApi();
        Assert.assertEquals((Object)api, (Object)api);
        Assert.assertEquals((Object)api.getSearchUrl(), (Object)apiClone.getSearchUrl());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)this.data.toString(), (Object)this.data.clone().toString());
    }

    @Test
    public void testToStringEmptyBuildData() {
        BuildData empty = new BuildData();
        Assert.assertThat((Object)empty.toString(), (Matcher)Matchers.endsWith((String)"[scmName=<null>,remoteUrls=[],buildsByBranchName={},lastBuild=null]"));
    }

    @Test
    public void testToStringNullSCMBuildData() {
        BuildData nullSCM = new BuildData(null);
        Assert.assertThat((Object)nullSCM.toString(), (Matcher)Matchers.endsWith((String)"[scmName=<null>,remoteUrls=[],buildsByBranchName={},lastBuild=null]"));
    }

    @Test
    public void testToStringNonNullSCMBuildData() {
        BuildData nonNullSCM = new BuildData("gitless");
        Assert.assertThat((Object)nonNullSCM.toString(), (Matcher)Matchers.endsWith((String)"[scmName=gitless,remoteUrls=[],buildsByBranchName={},lastBuild=null]"));
    }

    @Test
    public void testEquals() {
        Object nullData = null;
        Assert.assertFalse((String)"Null object not equal non-null", (boolean)this.data.equals(nullData));
        Assert.assertEquals((String)"Object not equal itself", (Object)this.data, (Object)this.data);
        Assert.assertTrue((String)"Object not equal itself", (boolean)this.data.equals((Object)this.data));
        Assert.assertEquals((String)"Object hashCode not equal itself", (long)this.data.hashCode(), (long)this.data.hashCode());
        BuildData data1 = this.data.clone();
        Assert.assertEquals((String)"Cloned objects not equal", (Object)data1, (Object)this.data);
        Assert.assertTrue((String)"Cloned objects not equal", (boolean)data1.equals((Object)this.data));
        Assert.assertTrue((String)"Cloned objects not equal", (boolean)this.data.equals((Object)data1));
        Assert.assertEquals((String)"Cloned object hashCodes not equal", (long)this.data.hashCode(), (long)data1.hashCode());
        Revision revision1 = new Revision(this.sha1);
        Build build1 = new Build(revision1, 1, Result.SUCCESS);
        data1.saveBuild(build1);
        Assert.assertFalse((String)"Distinct objects shouldn't be equal", (boolean)this.data.equals((Object)data1));
        Assert.assertFalse((String)"Distinct objects shouldn't be equal", (boolean)data1.equals((Object)this.data));
        BuildData data2 = this.data.clone();
        data2.saveBuild(build1);
        Assert.assertTrue((String)"Objects with same saved build not equal", (boolean)data2.equals((Object)data1));
        Assert.assertTrue((String)"Objects with same saved build not equal", (boolean)data1.equals((Object)data2));
        Assert.assertEquals((String)"Objects with same saved build not equal hashCodes", (long)data2.hashCode(), (long)data1.hashCode());
        String remoteUrl2 = "git://github.com/jenkinsci/git-plugin.git";
        data1.addRemoteUrl("git://github.com/jenkinsci/git-plugin.git");
        Assert.assertFalse((String)"Distinct objects shouldn't be equal", (boolean)this.data.equals((Object)data1));
        Assert.assertFalse((String)"Distinct objects shouldn't be equal", (boolean)data1.equals((Object)this.data));
        data2.addRemoteUrl("git://github.com/jenkinsci/git-plugin.git");
        Assert.assertTrue((String)"Objects with same remote URL not equal", (boolean)data2.equals((Object)data1));
        Assert.assertTrue((String)"Objects with same remote URL not equal", (boolean)data1.equals((Object)data2));
        Assert.assertEquals((String)"Objects with same remote URL not equal hashCodes", (long)data2.hashCode(), (long)data1.hashCode());
        String branchName = "origin/master";
        ArrayList<Branch> branches = new ArrayList<Branch>();
        Branch branch = new Branch(branchName, this.sha1);
        branches.add(branch);
        Revision revision2 = new Revision(this.sha1, branches);
        Build build2 = new Build(revision2, 1, Result.FAILURE);
        Assert.assertEquals((Object)build1, (Object)build2);
        data1.saveBuild(build2);
        data2.saveBuild(build2);
        Assert.assertTrue((boolean)data1.equals((Object)data2));
        Assert.assertEquals((long)data1.hashCode(), (long)data2.hashCode());
        data1.saveBuild(build1);
        data2.saveBuild(build2);
        Assert.assertTrue((boolean)data1.equals((Object)data2));
        Assert.assertEquals((long)data1.hashCode(), (long)data2.hashCode());
        data1.setScmName("scm 1");
        Assert.assertTrue((boolean)data1.equals((Object)data2));
        Assert.assertEquals((long)data1.hashCode(), (long)data2.hashCode());
        data2.setScmName("scm 2");
        Assert.assertTrue((boolean)data1.equals((Object)data2));
        Assert.assertEquals((long)data1.hashCode(), (long)data2.hashCode());
        BuildData emptyData = new BuildData();
        emptyData.remoteUrls = null;
        Assert.assertNotEquals((String)"Non-empty object equal empty", (Object)this.data, (Object)emptyData);
        Assert.assertNotEquals((String)"Empty object similar to non-empty", (Object)emptyData, (Object)this.data);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(BuildData.class).usingGetClass().suppress(new Warning[]{Warning.NONFINAL_FIELDS}).withIgnoredFields(new String[]{"index", "scmName"}).verify();
    }

    @Test
    public void testSetIndex() {
        this.data.setIndex(null);
        Assert.assertEquals(null, (Object)this.data.getIndex());
        this.data.setIndex(Integer.valueOf(-1));
        Assert.assertEquals(null, (Object)this.data.getIndex());
        this.data.setIndex(Integer.valueOf(0));
        Assert.assertEquals(null, (Object)this.data.getIndex());
        this.data.setIndex(Integer.valueOf(13));
        Assert.assertEquals((long)13L, (long)this.data.getIndex().intValue());
        this.data.setIndex(Integer.valueOf(-1));
        Assert.assertEquals(null, (Object)this.data.getIndex());
    }

    @Test
    public void testSimilarToHttpsRemoteURL() {
        String SIMPLE_URL = "https://github.com/jenkinsci/git-plugin";
        BuildData simple = new BuildData("git-https://github.com/jenkinsci/git-plugin");
        simple.addRemoteUrl("https://github.com/jenkinsci/git-plugin");
        this.permuteBaseURL("https://github.com/jenkinsci/git-plugin", simple);
    }

    @Test
    public void testSimilarToScpRemoteURL() {
        String SIMPLE_URL = "git@github.com:jenkinsci/git-plugin";
        BuildData simple = new BuildData("git-git@github.com:jenkinsci/git-plugin");
        simple.addRemoteUrl("git@github.com:jenkinsci/git-plugin");
        this.permuteBaseURL("git@github.com:jenkinsci/git-plugin", simple);
    }

    @Test
    public void testSimilarToSshRemoteURL() {
        String SIMPLE_URL = "ssh://git@github.com/jenkinsci/git-plugin";
        BuildData simple = new BuildData("git-ssh://git@github.com/jenkinsci/git-plugin");
        simple.addRemoteUrl("ssh://git@github.com/jenkinsci/git-plugin");
        this.permuteBaseURL("ssh://git@github.com/jenkinsci/git-plugin", simple);
    }

    private void permuteBaseURL(String simpleURL, BuildData simple) {
        String TRAILING_SLASH_URL = simpleURL + "/";
        BuildData trailingSlash = new BuildData("git-" + TRAILING_SLASH_URL);
        trailingSlash.addRemoteUrl(TRAILING_SLASH_URL);
        Assert.assertTrue((String)("Trailing slash not similar to simple URL " + TRAILING_SLASH_URL), (boolean)trailingSlash.similarTo(simple));
        String TRAILING_SLASHES_URL = TRAILING_SLASH_URL + "//";
        BuildData trailingSlashes = new BuildData("git-" + TRAILING_SLASHES_URL);
        trailingSlashes.addRemoteUrl(TRAILING_SLASHES_URL);
        Assert.assertTrue((String)("Trailing slashes not similar to simple URL " + TRAILING_SLASHES_URL), (boolean)trailingSlashes.similarTo(simple));
        String DOT_GIT_URL = simpleURL + ".git";
        BuildData dotGit = new BuildData("git-" + DOT_GIT_URL);
        dotGit.addRemoteUrl(DOT_GIT_URL);
        Assert.assertTrue((String)("Dot git not similar to simple URL " + DOT_GIT_URL), (boolean)dotGit.similarTo(simple));
        String DOT_GIT_TRAILING_SLASH_URL = DOT_GIT_URL + "/";
        BuildData dotGitTrailingSlash = new BuildData("git-" + DOT_GIT_TRAILING_SLASH_URL);
        dotGitTrailingSlash.addRemoteUrl(DOT_GIT_TRAILING_SLASH_URL);
        Assert.assertTrue((String)("Dot git trailing slash not similar to dot git URL " + DOT_GIT_TRAILING_SLASH_URL), (boolean)dotGitTrailingSlash.similarTo(dotGit));
        String DOT_GIT_TRAILING_SLASHES_URL = DOT_GIT_TRAILING_SLASH_URL + "///";
        BuildData dotGitTrailingSlashes = new BuildData("git-" + DOT_GIT_TRAILING_SLASHES_URL);
        dotGitTrailingSlashes.addRemoteUrl(DOT_GIT_TRAILING_SLASHES_URL);
        Assert.assertTrue((String)("Dot git trailing slashes not similar to dot git URL " + DOT_GIT_TRAILING_SLASHES_URL), (boolean)dotGitTrailingSlashes.similarTo(dotGit));
    }

    @Test
    public void testSimilarToContainsNullURL() {
        String SIMPLE_URL = "ssh://git@github.com/jenkinsci/git-plugin";
        BuildData simple = new BuildData("git-ssh://git@github.com/jenkinsci/git-plugin");
        simple.addRemoteUrl("ssh://git@github.com/jenkinsci/git-plugin");
        simple.addRemoteUrl(null);
        simple.addRemoteUrl("ssh://git@github.com/jenkinsci/git-plugin");
        BuildData simple2 = simple.clone();
        Assert.assertTrue((boolean)simple.similarTo(simple2));
        BuildData simple3 = new BuildData("git-ssh://git@github.com/jenkinsci/git-plugin");
        simple3.addRemoteUrl("ssh://git@github.com/jenkinsci/git-plugin");
        simple3.addRemoteUrl(null);
        simple3.addRemoteUrl("ssh://git@github.com/jenkinsci/git-plugin");
        Assert.assertTrue((boolean)simple.similarTo(simple3));
    }

    @Test
    public void testGetIndex() {
        Assert.assertEquals(null, (Object)this.data.getIndex());
    }

    @Test
    public void testGetRemoteUrls() {
        Assert.assertTrue((boolean)this.data.getRemoteUrls().isEmpty());
    }

    @Test
    public void testClone() {
    }

    @Test
    public void testSimilarTo() {
        this.data.addRemoteUrl("https://github.com/jenkinsci/git-plugin");
        BuildData dataNull = null;
        Assert.assertFalse((String)"Null object similar to non-null", (boolean)this.data.similarTo(dataNull));
        BuildData emptyData = new BuildData();
        Assert.assertFalse((String)"Non-empty object similar to empty", (boolean)this.data.similarTo(emptyData));
        Assert.assertFalse((String)"Empty object similar to non-empty", (boolean)emptyData.similarTo(this.data));
        emptyData.remoteUrls = null;
        Assert.assertFalse((String)"Non-empty object similar to empty", (boolean)this.data.similarTo(emptyData));
        Assert.assertFalse((String)"Empty object similar to non-empty", (boolean)emptyData.similarTo(this.data));
        Assert.assertTrue((String)"Object not similar to itself", (boolean)this.data.similarTo(this.data));
        ArrayList emptyList = new ArrayList();
        Assert.assertFalse((String)"Object similar to data with SCM name", (boolean)this.data.similarTo(new BuildData("abc")));
        Assert.assertFalse((String)"Object similar to data with SCM name & empty", (boolean)this.data.similarTo(new BuildData("abc", emptyList)));
        BuildData dataSCM = new BuildData("scm");
        Assert.assertFalse((String)"Object similar to data with SCM name", (boolean)dataSCM.similarTo(this.data));
        Assert.assertTrue((String)"Object with SCM name not similar to data with SCM name", (boolean)dataSCM.similarTo(new BuildData("abc")));
        Assert.assertTrue((String)"Object with SCM name not similar to data with SCM name & empty", (boolean)dataSCM.similarTo(new BuildData("abc", emptyList)));
        BuildData dataClone = this.data.clone();
        Assert.assertTrue((String)"Clone not similar to origin", (boolean)dataClone.similarTo(this.data));
        Assert.assertTrue((String)"Origin not similar to clone", (boolean)this.data.similarTo(dataClone));
        Revision revision1 = new Revision(this.sha1);
        Build build1 = new Build(revision1, 1, Result.SUCCESS);
        dataClone.saveBuild(build1);
        Assert.assertFalse((String)"Unmodified origin similar to modified clone", (boolean)this.data.similarTo(dataClone));
        Assert.assertFalse((String)"Modified clone similar to unmodified origin", (boolean)dataClone.similarTo(this.data));
        Assert.assertTrue((String)"Modified clone not similar to itself", (boolean)dataClone.similarTo(dataClone));
        BuildData data2 = this.data.clone();
        data2.saveBuild(build1);
        Assert.assertFalse((String)"Unmodified origin similar to modified clone", (boolean)this.data.similarTo(data2));
        Assert.assertTrue((String)"Objects with same saved build not similar (1)", (boolean)data2.similarTo(dataClone));
        Assert.assertTrue((String)"Objects with same saved build not similar (2)", (boolean)dataClone.similarTo(data2));
        String remoteUrl = "git://github.com/jenkinsci/git-client-plugin.git";
        dataClone.addRemoteUrl("git://github.com/jenkinsci/git-client-plugin.git");
        Assert.assertFalse((String)"Distinct objects shouldn't be similar (1)", (boolean)this.data.similarTo(dataClone));
        Assert.assertFalse((String)"Distinct objects shouldn't be similar (2)", (boolean)dataClone.similarTo(this.data));
        data2.addRemoteUrl("git://github.com/jenkinsci/git-client-plugin.git");
        Assert.assertTrue((String)"Objects with same remote URL dissimilar", (boolean)data2.similarTo(dataClone));
        Assert.assertTrue((String)"Objects with same remote URL dissimilar", (boolean)dataClone.similarTo(data2));
        String trailingSlash = "git-client-plugin.git/";
        dataClone.addRemoteUrl("git-client-plugin.git/");
        Assert.assertFalse((String)"Distinct objects shouldn't be similar", (boolean)this.data.similarTo(dataClone));
        Assert.assertFalse((String)"Distinct objects shouldn't be similar", (boolean)dataClone.similarTo(this.data));
        data2.addRemoteUrl("git-client-plugin.git/");
        Assert.assertTrue((String)"Objects with same remote URL dissimilar", (boolean)data2.similarTo(dataClone));
        Assert.assertTrue((String)"Objects with same remote URL dissimilar", (boolean)dataClone.similarTo(data2));
        String noSlash = "git-client-plugin";
        dataClone.addRemoteUrl("git-client-plugin");
        Assert.assertFalse((String)"Distinct objects shouldn't be similar", (boolean)this.data.similarTo(dataClone));
        Assert.assertFalse((String)"Distinct objects shouldn't be similar", (boolean)dataClone.similarTo(this.data));
        data2.addRemoteUrl("git-client-plugin");
        Assert.assertTrue((String)"Objects with same remote URL dissimilar", (boolean)data2.similarTo(dataClone));
        Assert.assertTrue((String)"Objects with same remote URL dissimilar", (boolean)dataClone.similarTo(data2));
        String branchName = "origin/master";
        ArrayList<Branch> branches = new ArrayList<Branch>();
        Branch branch = new Branch(branchName, this.sha1);
        branches.add(branch);
        Revision revision2 = new Revision(this.sha1, branches);
        Build build2 = new Build(revision2, 1, Result.FAILURE);
        dataClone.saveBuild(build2);
        Assert.assertTrue((String)"Another saved build, still similar (1)", (boolean)dataClone.similarTo(data2));
        Assert.assertTrue((String)"Another saved build, still similar (2)", (boolean)data2.similarTo(dataClone));
        data2.saveBuild(build2);
        Assert.assertTrue((String)"Another saved build, still similar (3)", (boolean)dataClone.similarTo(data2));
        Assert.assertTrue((String)"Another saved build, still similar (4)", (boolean)data2.similarTo(dataClone));
        dataClone.saveBuild(build1);
        Assert.assertTrue((String)"Saved build with different results, similar (5)", (boolean)dataClone.similarTo(data2));
        Assert.assertTrue((String)"Saved build with different results, similar (6)", (boolean)data2.similarTo(dataClone));
        data2.saveBuild(build2);
        Assert.assertTrue((String)"Saved build with different results, similar (7)", (boolean)dataClone.similarTo(data2));
        Assert.assertTrue((String)"Saved build with different results, similar (8)", (boolean)data2.similarTo(dataClone));
        dataClone.setScmName("scm 1");
        Assert.assertTrue((boolean)dataClone.similarTo(data2));
        data2.setScmName("scm 2");
        Assert.assertTrue((boolean)dataClone.similarTo(data2));
    }

    @Test
    public void testHashCodeEmptyData() {
        BuildData emptyData = new BuildData();
        Assert.assertEquals((long)emptyData.hashCode(), (long)emptyData.hashCode());
        emptyData.remoteUrls = null;
        Assert.assertEquals((long)emptyData.hashCode(), (long)emptyData.hashCode());
    }
}

