/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.AbstractGitRepository;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import jenkins.plugins.git.GitSampleRepoRule;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RefSpec;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class CandidateRevisionsTest
extends AbstractGitRepository {
    private File testGitDir2;
    private GitClient testGitClient2;
    @Rule
    public GitSampleRepoRule testGitRepo2 = new GitSampleRepoRule();

    @Before
    public void createSecondGitRepository() throws Exception {
        this.testGitRepo2.init();
        this.testGitDir2 = this.testGitRepo2.getRoot();
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        this.testGitClient2 = Git.with((TaskListener)listener, (EnvVars)new EnvVars()).in(this.testGitDir2).using(new Random().nextBoolean() ? "git" : "jgit").getClient();
    }

    @Test
    public void testChooseWithMultipleTag() throws Exception {
        this.commitNewFile("file-1-in-repo-1");
        ObjectId commit1 = this.testGitClient.revParse("HEAD");
        Assert.assertEquals((Object)commit1, (Object)this.testGitClient.revParse("master"));
        this.testGitClient.tag("tag/a", "Applied tag/a to commit 1");
        this.commitNewFile("file-2-in-repo-1");
        ObjectId commit2 = this.testGitClient.revParse("HEAD");
        Assert.assertEquals((Object)commit2, (Object)this.testGitClient.revParse("master"));
        this.testGitClient.tag("tag/b", "Applied tag/b to commit 2");
        this.testGitClient.tag("tag/c", "Applied tag/c to commit 2");
        Assert.assertEquals((Object)commit2, (Object)this.testGitClient.revParse("tag/b"));
        Assert.assertEquals((Object)commit2, (Object)this.testGitClient.revParse("tag/c"));
        this.commitNewFile("file-3-in-repo-1");
        ObjectId commit3 = this.testGitClient.revParse("HEAD");
        Assert.assertEquals((Object)commit3, (Object)this.testGitClient.revParse("master"));
        RefSpec tagsRefSpec = new RefSpec("+refs/tags/tag/*:refs/remotes/origin/tags/tag/*");
        this.testGitClient2.clone_().refspecs(Arrays.asList(tagsRefSpec)).repositoryName("origin").url(this.testGitDir.getAbsolutePath()).execute();
        String randomTag = new Random().nextBoolean() ? "tag/b" : "tag/c";
        this.testGitClient2.checkout().branch("my-branch").ref(randomTag).execute();
        Assert.assertEquals((Object)commit2, (Object)this.testGitClient2.revParse("tag/b"));
        Assert.assertEquals((Object)commit2, (Object)this.testGitClient2.revParse("tag/c"));
        DefaultBuildChooser buildChooser = (DefaultBuildChooser)new GitSCM(this.testGitDir.getAbsolutePath()).getBuildChooser();
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.hasBeenBuilt(this.testGitClient2.revParse("tag/a"))).thenReturn((Object)true);
        Mockito.when((Object)buildData.hasBeenBuilt(this.testGitClient2.revParse("tag/b"))).thenReturn((Object)false);
        Mockito.when((Object)buildData.hasBeenBuilt(this.testGitClient2.revParse("tag/c"))).thenReturn((Object)false);
        BuildChooserContext context = (BuildChooserContext)Mockito.mock(BuildChooserContext.class);
        Mockito.when((Object)context.getEnvironment()).thenReturn((Object)new EnvVars());
        Collection candidateRevisions = buildChooser.getCandidateRevisions(false, "tag/*", this.testGitClient2, null, buildData, context);
        Assert.assertEquals((long)1L, (long)candidateRevisions.size());
        String name = ((Branch)((Revision)candidateRevisions.iterator().next()).getBranches().iterator().next()).getName();
        Assert.assertTrue((String)("Expected .*/tags/b or .*/tags/c, was '" + name + "'"), (boolean)name.matches("(origin|refs)/tags/tag/[bc]"));
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

