/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.GitUtils;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import jenkins.plugins.git.GitSampleRepoRule;
import org.eclipse.jgit.lib.ObjectId;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GitUtilsTest {
    @ClassRule
    public static GitSampleRepoRule originRepo = new GitSampleRepoRule();
    @ClassRule
    public static TemporaryFolder repoParentFolder = new TemporaryFolder();
    private static final String[] HEAD_BRANCH_NAMES = new String[]{"master", "sally-2", "baker-1", "able-4"};
    private static final String OLDER_BRANCH_NAME = "older-branch";
    private static ObjectId headId = null;
    private static ObjectId headTag0Id = null;
    private static ObjectId priorHeadId = null;
    private static Revision headRevision = null;
    private static Revision headTag0Revision = null;
    private static Revision priorRevision = null;
    private static final String PRIOR_TAG_NAME_1 = "prior-tag-1";
    private static final String PRIOR_TAG_NAME_2 = "prior-tag-2-annotated";
    private static final String HEAD_TAG_NAME_0 = "head-tag-0";
    private static final String HEAD_TAG_NAME_1 = "head-tag-1";
    private static final String HEAD_TAG_NAME_2 = "head-tag-2-annotated";
    private final String[] tagNames = new String[]{"prior-tag-1", "prior-tag-2-annotated", "head-tag-0", "head-tag-1", "head-tag-2-annotated"};
    private static List<BranchSpec> branchSpecList = null;
    private static List<BranchSpec> priorBranchSpecList = null;
    private static List<Branch> branchList = null;
    private static final EnvVars ENV = new EnvVars();
    private static final TaskListener NULL_LISTENER = StreamTaskListener.NULL;
    private GitUtils gitUtils;
    private static GitClient gitClient;
    private static final Random RANDOM;

    @BeforeClass
    public static void createSampleOriginRepo() throws Exception {
        String fileName = "README";
        originRepo.init();
        originRepo.git("config", "user.name", "Author User Name");
        originRepo.git("config", "user.email", "author.user.name@mail.example.com");
        originRepo.git("tag", PRIOR_TAG_NAME_1);
        originRepo.git("tag", "-a", PRIOR_TAG_NAME_2, "-m", "Annotated tag prior-tag-2-annotated");
        priorHeadId = ObjectId.fromString((String)originRepo.head());
        originRepo.git("checkout", "-b", OLDER_BRANCH_NAME);
        branchList = new ArrayList<Branch>();
        branchList.add(new Branch(OLDER_BRANCH_NAME, priorHeadId));
        branchList.add(new Branch("refs/tags/prior-tag-1", priorHeadId));
        branchList.add(new Branch("refs/tags/prior-tag-2-annotated", priorHeadId));
        priorRevision = new Revision(priorHeadId, branchList);
        priorBranchSpecList = new ArrayList<BranchSpec>();
        priorBranchSpecList.add(new BranchSpec(OLDER_BRANCH_NAME));
        originRepo.git("checkout", "master");
        originRepo.write(fileName, "This is the head-tag-0 README file " + RANDOM.nextInt());
        originRepo.git("add", fileName);
        originRepo.git("commit", "-m", "Adding " + fileName + " tagged " + HEAD_TAG_NAME_0, fileName);
        originRepo.git("tag", HEAD_TAG_NAME_0);
        headTag0Id = ObjectId.fromString((String)originRepo.head());
        headTag0Revision = new Revision(headTag0Id);
        originRepo.write(fileName, "This is the README file " + RANDOM.nextInt());
        originRepo.git("add", fileName);
        originRepo.git("commit", "-m", "Adding " + fileName, fileName);
        originRepo.git("tag", HEAD_TAG_NAME_1);
        originRepo.git("tag", "-a", HEAD_TAG_NAME_2, "-m", "Annotated tag head-tag-2-annotated");
        headId = ObjectId.fromString((String)originRepo.head());
        branchSpecList = new ArrayList<BranchSpec>();
        branchList = new ArrayList<Branch>();
        branchSpecList.add(new BranchSpec("master"));
        branchSpecList.add(new BranchSpec("refs/tags/head-tag-0"));
        branchSpecList.add(new BranchSpec("refs/tags/head-tag-1"));
        branchSpecList.add(new BranchSpec("refs/tags/head-tag-2-annotated"));
        branchList.add(new Branch("master", headId));
        branchList.add(new Branch("refs/tags/head-tag-0", headId));
        branchList.add(new Branch("refs/tags/head-tag-1", headId));
        branchList.add(new Branch("refs/tags/head-tag-2-annotated", headId));
        for (String branchName : HEAD_BRANCH_NAMES) {
            if (branchName.equals("master")) continue;
            originRepo.git("checkout", "-b", branchName);
            branchSpecList.add(new BranchSpec(branchName));
            branchList.add(new Branch(branchName, headId));
        }
        originRepo.git("checkout", "master");
        headRevision = new Revision(headId, branchList);
        File gitDir = repoParentFolder.newFolder("test-repo");
        gitClient = Git.with((TaskListener)NULL_LISTENER, (EnvVars)ENV).in(gitDir).using("git").getClient();
        gitClient.init();
        gitClient.clone_().url(originRepo.fileUrl()).repositoryName("origin").execute();
        gitClient.checkout("origin/master", "master");
    }

    @Before
    public void createGitUtils() throws Exception {
        this.gitUtils = new GitUtils(NULL_LISTENER, gitClient);
    }

    @Test
    public void testSortBranchesForRevision_Revision_List() {
        Revision result = this.gitUtils.sortBranchesForRevision(headRevision, branchSpecList);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)headRevision));
    }

    @Test
    public void testSortBranchesForRevision_Revision_List_Prior() {
        Revision result = this.gitUtils.sortBranchesForRevision(priorRevision, priorBranchSpecList);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)priorRevision));
    }

    @Test
    public void testSortBranchesForRevision_Revision_List_Mix_1() {
        Revision result = this.gitUtils.sortBranchesForRevision(headRevision, priorBranchSpecList);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)headRevision));
    }

    @Test
    public void testSortBranchesForRevision_Revision_List_Mix_2() {
        Revision result = this.gitUtils.sortBranchesForRevision(priorRevision, branchSpecList);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)priorRevision));
    }

    @Test
    public void testSortBranchesForRevision_Revision_List_Prior_3_args() {
        Revision result = this.gitUtils.sortBranchesForRevision(headRevision, branchSpecList, ENV);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)headRevision));
    }

    @Test
    public void testSortBranchesForRevision_3args() {
        Revision result = this.gitUtils.sortBranchesForRevision(headRevision, branchSpecList, ENV);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)headRevision));
    }

    @Test
    public void testSortBranchesForRevision_3args_Prior() {
        Revision result = this.gitUtils.sortBranchesForRevision(priorRevision, branchSpecList, ENV);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)priorRevision));
    }

    @Test
    public void testGetRevisionContainingBranch() throws Exception {
        for (String branchName : HEAD_BRANCH_NAMES) {
            Revision revision = this.gitUtils.getRevisionContainingBranch("origin/" + branchName);
            Assert.assertThat((Object)revision, (Matcher)Matchers.is((Object)headRevision));
        }
    }

    @Test
    public void testGetRevisionContainingBranch_OlderName() throws Exception {
        Revision revision = this.gitUtils.getRevisionContainingBranch("origin/older-branch");
        Assert.assertThat((Object)revision, (Matcher)Matchers.is((Object)priorRevision));
    }

    @Test
    public void testGetRevisionContainingBranch_UseTagNameHead0() throws Exception {
        Revision revision = this.gitUtils.getRevisionContainingBranch("refs/tags/head-tag-0");
        Assert.assertThat((Object)revision, (Matcher)Matchers.is((Object)headTag0Revision));
    }

    @Test
    public void testGetRevisionContainingBranch_UseTagNameHead1() throws Exception {
        Revision revision = this.gitUtils.getRevisionContainingBranch("refs/tags/head-tag-1");
        Assert.assertThat((Object)revision, (Matcher)Matchers.is((Object)headRevision));
    }

    @Test
    public void testGetRevisionContainingBranch_UseTagNameHead2() throws Exception {
        Revision revision = this.gitUtils.getRevisionContainingBranch("refs/tags/head-tag-2-annotated");
        Assert.assertThat((Object)revision, (Matcher)Matchers.is((Object)headRevision));
    }

    @Test
    public void testGetRevisionContainingBranch_UseTagNamePrior1() throws Exception {
        Revision revision = this.gitUtils.getRevisionContainingBranch("refs/tags/prior-tag-1");
        Assert.assertThat((Object)revision, (Matcher)Matchers.is((Object)priorRevision));
    }

    @Test
    public void testGetRevisionContainingBranch_UseTagNamePrior2() throws Exception {
        Revision revision = this.gitUtils.getRevisionContainingBranch("refs/tags/prior-tag-2-annotated");
        Assert.assertThat((Object)revision, (Matcher)Matchers.is((Object)priorRevision));
    }

    @Test
    public void testGetRevisionContainingBranch_InvalidBranchName() throws Exception {
        Revision revision = this.gitUtils.getRevisionContainingBranch("origin/not-a-valid-branch-name");
        Assert.assertThat((Object)revision, (Matcher)Matchers.is((Matcher)Matchers.nullValue(Revision.class)));
    }

    @Test
    public void testGetRevisionContainingBranch_InvalidTagName() throws Exception {
        Revision revision = this.gitUtils.getRevisionContainingBranch("ref/tags/not-a-valid-tag-name");
        Assert.assertThat((Object)revision, (Matcher)Matchers.is((Matcher)Matchers.nullValue(Revision.class)));
    }

    @Test
    public void testGetRevisionForSHA1() throws Exception {
        Revision revision = this.gitUtils.getRevisionForSHA1(headId);
        Assert.assertThat((Object)revision, (Matcher)Matchers.is((Object)headRevision));
    }

    @Test
    public void testGetRevisionForSHA1PriorRevision() throws Exception {
        Revision revision = this.gitUtils.getRevisionForSHA1(priorHeadId);
        Assert.assertThat((Object)revision, (Matcher)Matchers.is((Object)priorRevision));
    }

    @Test
    public void testGetRevisionForSHA1UnknownRevision() throws Exception {
        ObjectId unknown = ObjectId.fromString((String)"a422d10c6dc4262effb12f9e7a64911111000000");
        Revision unknownRevision = new Revision(unknown);
        Revision revision = this.gitUtils.getRevisionForSHA1(unknown);
        Assert.assertThat((Object)revision, (Matcher)Matchers.is((Object)unknownRevision));
    }

    @Test
    public void testFilterTipBranches() throws Exception {
        ArrayList<Revision> multiRevisionList = new ArrayList<Revision>();
        multiRevisionList.add(priorRevision);
        multiRevisionList.add(headRevision);
        ArrayList<Revision> filteredRevisions = new ArrayList<Revision>();
        filteredRevisions.add(headRevision);
        List result = this.gitUtils.filterTipBranches(multiRevisionList);
        Assert.assertThat((Object)result, (Matcher)Matchers.is(filteredRevisions));
    }

    @Test
    public void testFilterTipBranchesNoRemovals() throws Exception {
        ArrayList<Revision> headRevisionList = new ArrayList<Revision>();
        headRevisionList.add(headRevision);
        List result = this.gitUtils.filterTipBranches(headRevisionList);
        Assert.assertThat((Object)result, (Matcher)Matchers.is(headRevisionList));
    }

    @Test
    public void testFilterTipBranchesNoRemovalsNonTip() throws Exception {
        ArrayList<Revision> priorRevisionList = new ArrayList<Revision>();
        priorRevisionList.add(priorRevision);
        List result = this.gitUtils.filterTipBranches(priorRevisionList);
        Assert.assertThat((Object)result, (Matcher)Matchers.is(priorRevisionList));
    }

    @Test
    public void testFixupNames() {
        String[] names = new String[]{"origin", "origin2", null, "", null};
        String[] urls = new String[]{"git://github.com/jenkinsci/git-plugin.git", "git@github.com:jenkinsci/git-plugin.git", "https://github.com/jenkinsci/git-plugin", "https://github.com/jenkinsci/git-plugin.git", "ssh://github.com/jenkinsci/git-plugin.git"};
        String[] expected = new String[]{"origin", "origin2", "origin1", "origin3", "origin4"};
        String[] actual = GitUtils.fixupNames((String[])names, (String[])urls);
        Assert.assertThat((Object)expected, (Matcher)Matchers.is((Object)actual));
    }

    private Set<String> getExpectedNames() {
        HashSet<String> names = new HashSet<String>(HEAD_BRANCH_NAMES.length + this.tagNames.length + 1);
        for (String branchName : HEAD_BRANCH_NAMES) {
            names.add("origin/" + branchName);
        }
        names.add("origin/older-branch");
        for (String tagName : this.tagNames) {
            names.add("refs/tags/" + tagName);
        }
        return names;
    }

    private Set<String> getActualNames(@NonNull Collection<Revision> revisions) {
        HashSet<String> names = new HashSet<String>(revisions.size());
        for (Revision revision : revisions) {
            for (Branch branch : revision.getBranches()) {
                names.add(branch.getName());
            }
        }
        return names;
    }

    @Test
    public void testGetAllBranchRevisions() throws Exception {
        Collection allRevisions = this.gitUtils.getAllBranchRevisions();
        Assert.assertThat((Object)allRevisions, (Matcher)Matchers.hasItem((Object)headRevision));
        Set<String> expectedNames = this.getExpectedNames();
        Set<String> actualNames = this.getActualNames(allRevisions);
        Assert.assertThat(actualNames, (Matcher)Matchers.is(expectedNames));
    }

    static {
        RANDOM = new Random();
    }
}

