/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.FreeStyleBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.BuildChooserSetting;
import hudson.plugins.git.extensions.impl.IgnoreNotifyCommit;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.scm.SCMRevisionState;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitRefSCMHead;
import jenkins.plugins.git.GitRemoteHeadRefAction;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSCMSourceDefaults;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.plugins.git.GitTagSCMRevision;
import jenkins.plugins.git.traits.BranchDiscoveryTrait;
import jenkins.plugins.git.traits.DiscoverOtherRefsTrait;
import jenkins.plugins.git.traits.IgnoreOnPushNotificationTrait;
import jenkins.plugins.git.traits.PruneStaleBranchTrait;
import jenkins.plugins.git.traits.TagDiscoveryTrait;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.hamcrest.Matcher;
import org.hamcrest.beans.HasPropertyWithValue;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.CombinableMatcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.hamcrest.number.OrderingComparison;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.TestJGitAPIImpl;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.mockito.Mockito;

public class AbstractGitSCMSourceTest {
    static final String GitBranchSCMHead_DEV_MASTER = "[GitBranchSCMHead{name='dev', ref='refs/heads/dev'}, GitBranchSCMHead{name='master', ref='refs/heads/master'}]";
    static final String GitBranchSCMHead_DEV_DEV2_MASTER = "[GitBranchSCMHead{name='dev', ref='refs/heads/dev'}, GitBranchSCMHead{name='dev2', ref='refs/heads/dev2'}, GitBranchSCMHead{name='master', ref='refs/heads/master'}]";
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    @Rule
    public GitSampleRepoRule sampleRepo2 = new GitSampleRepoRule();
    private int wsCount;
    static GitSampleRepoRule sharedSampleRepo;

    @Test
    public void retrieveHeads() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2");
        this.sampleRepo.write("file", "modified again");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_DEV2_MASTER, (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void retrieveHeadsRequiresBranchDiscovery() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"[]", (Object)source.fetch((TaskListener)listener).toString());
        source.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2");
        this.sampleRepo.write("file", "modified again");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_DEV2_MASTER, (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void retrieveHeadsSupportsTagDiscovery_ignoreTagsWithoutTagDiscoveryTrait() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        this.sampleRepo.git("tag", "lightweight");
        this.sampleRepo.write("file", "modified2");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        this.sampleRepo.git("tag", "-a", "annotated", "-m", "annotated");
        this.sampleRepo.write("file", "modified3");
        this.sampleRepo.git("commit", "--all", "--message=dev3");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"[]", (Object)source.fetch((TaskListener)listener).toString());
        source.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2");
        this.sampleRepo.write("file", "modified again");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_DEV2_MASTER, (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void retrieveHeadsSupportsTagDiscovery_findTagsWithTagDiscoveryTrait() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev-commit-message");
        long beforeLightweightTag = System.currentTimeMillis();
        this.sampleRepo.git("tag", "lightweight");
        long afterLightweightTag = System.currentTimeMillis();
        this.sampleRepo.write("file", "modified2");
        this.sampleRepo.git("commit", "--all", "--message=dev2-commit-message");
        long beforeAnnotatedTag = System.currentTimeMillis();
        this.sampleRepo.git("tag", "-a", "annotated", "-m", "annotated");
        long afterAnnotatedTag = System.currentTimeMillis();
        this.sampleRepo.write("file", "modified3");
        this.sampleRepo.git("commit", "--all", "--message=dev3-commit-message");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(new ArrayList());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"[]", (Object)source.fetch((TaskListener)listener).toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        Set scmHeadSet = source.fetch((TaskListener)listener);
        long now = System.currentTimeMillis();
        block8: for (SCMHead scmHead : scmHeadSet) {
            if (!(scmHead instanceof GitTagSCMHead)) continue;
            GitTagSCMHead tagHead = (GitTagSCMHead)scmHead;
            long fileTimeStampFuzz = this.isWindows() ? 2000L : 1000L;
            switch (scmHead.getName()) {
                case "lightweight": {
                    long timeStampDelta = afterLightweightTag - tagHead.getTimestamp();
                    Assert.assertThat((Object)timeStampDelta, (Matcher)Is.is((Matcher)CombinableMatcher.both((Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L))).and(OrderingComparison.lessThanOrEqualTo((Comparable)Long.valueOf(afterLightweightTag - beforeLightweightTag + fileTimeStampFuzz)))));
                    continue block8;
                }
                case "annotated": {
                    long timeStampDelta = afterAnnotatedTag - tagHead.getTimestamp();
                    Assert.assertThat((Object)timeStampDelta, (Matcher)Is.is((Matcher)CombinableMatcher.both((Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L))).and(OrderingComparison.lessThanOrEqualTo((Comparable)Long.valueOf(afterAnnotatedTag - beforeAnnotatedTag + fileTimeStampFuzz)))));
                    continue block8;
                }
            }
            Assert.fail((String)("Unexpected tag head '" + scmHead.getName() + "'"));
        }
        String expected = "[SCMHead{'annotated'}, GitBranchSCMHead{name='dev', ref='refs/heads/dev'}, SCMHead{'lightweight'}, GitBranchSCMHead{name='master', ref='refs/heads/master'}]";
        Assert.assertEquals((Object)expected, (Object)scmHeadSet.toString());
        Assert.assertEquals((Object)expected, (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2");
        this.sampleRepo.write("file", "modified again");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        expected = "[SCMHead{'annotated'}, GitBranchSCMHead{name='dev', ref='refs/heads/dev'}, GitBranchSCMHead{name='dev2', ref='refs/heads/dev2'}, SCMHead{'lightweight'}, GitBranchSCMHead{name='master', ref='refs/heads/master'}]";
        Assert.assertEquals((Object)expected, (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void retrieveHeadsSupportsTagDiscovery_onlyTagsWithoutBranchDiscoveryTrait() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        this.sampleRepo.git("tag", "lightweight");
        this.sampleRepo.write("file", "modified2");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        this.sampleRepo.git("tag", "-a", "annotated", "-m", "annotated");
        this.sampleRepo.write("file", "modified3");
        this.sampleRepo.git("commit", "--all", "--message=dev3");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(new ArrayList());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"[]", (Object)source.fetch((TaskListener)listener).toString());
        source.setTraits(Collections.singletonList(new TagDiscoveryTrait()));
        Assert.assertEquals((Object)"[SCMHead{'annotated'}, SCMHead{'lightweight'}]", (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)"[SCMHead{'annotated'}, SCMHead{'lightweight'}]", (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void retrieveRevisions() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        this.sampleRepo.git("tag", "lightweight");
        this.sampleRepo.write("file", "modified2");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        this.sampleRepo.git("tag", "-a", "annotated", "-m", "annotated");
        this.sampleRepo.write("file", "modified3");
        this.sampleRepo.git("commit", "--all", "--message=dev3");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(new ArrayList());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertThat((Object)source.fetchRevisions((TaskListener)listener, null), (Matcher)IsCollectionWithSize.hasSize((int)0));
        source.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        Assert.assertThat((Object)source.fetchRevisions((TaskListener)listener, null), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"dev", "master"}));
        source.setTraits(Collections.singletonList(new TagDiscoveryTrait()));
        Assert.assertThat((Object)source.fetchRevisions((TaskListener)listener, null), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"annotated", "lightweight"}));
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        Assert.assertThat((Object)source.fetchRevisions((TaskListener)listener, null), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"dev", "master", "annotated", "lightweight"}));
    }

    @Test
    public void retrieveByName() throws Exception {
        this.sampleRepo.init();
        String masterHash = this.sampleRepo.head();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        this.sampleRepo.git("tag", "v1");
        String v1Hash = this.sampleRepo.head();
        this.sampleRepo.write("file", "modified2");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        this.sampleRepo.git("tag", "-a", "v2", "-m", "annotated");
        String v2Hash = this.sampleRepo.head();
        this.sampleRepo.write("file", "modified3");
        this.sampleRepo.git("commit", "--all", "--message=dev3");
        String devHash = this.sampleRepo.head();
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(new ArrayList());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        listener.getLogger().println("\n=== fetch('master') ===\n");
        SCMRevision rev = source.fetch("master", (TaskListener)listener, null);
        Assert.assertThat((Object)rev, (Matcher)IsInstanceOf.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        Assert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Is.is((Object)masterHash));
        listener.getLogger().println("\n=== fetch('dev') ===\n");
        rev = source.fetch("dev", (TaskListener)listener, null);
        Assert.assertThat((Object)rev, (Matcher)IsInstanceOf.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        Assert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Is.is((Object)devHash));
        listener.getLogger().println("\n=== fetch('v1') ===\n");
        rev = source.fetch("v1", (TaskListener)listener, null);
        Assert.assertThat((Object)rev, (Matcher)IsInstanceOf.instanceOf(GitTagSCMRevision.class));
        Assert.assertThat((Object)((GitTagSCMRevision)rev).getHash(), (Matcher)Is.is((Object)v1Hash));
        listener.getLogger().println("\n=== fetch('v2') ===\n");
        rev = source.fetch("v2", (TaskListener)listener, null);
        Assert.assertThat((Object)rev, (Matcher)IsInstanceOf.instanceOf(GitTagSCMRevision.class));
        Assert.assertThat((Object)((GitTagSCMRevision)rev).getHash(), (Matcher)Is.is((Object)v2Hash));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", masterHash);
        rev = source.fetch(masterHash, (TaskListener)listener, null);
        Assert.assertThat((Object)rev, (Matcher)IsInstanceOf.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        Assert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Is.is((Object)masterHash));
        Assert.assertThat((Object)rev.getHead().getName(), (Matcher)Is.is((Object)"master"));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", masterHash.substring(0, 10));
        rev = source.fetch(masterHash.substring(0, 10), (TaskListener)listener, null);
        Assert.assertThat((Object)rev, (Matcher)IsInstanceOf.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        Assert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Is.is((Object)masterHash));
        Assert.assertThat((Object)rev.getHead().getName(), (Matcher)Is.is((Object)"master"));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", devHash);
        rev = source.fetch(devHash, (TaskListener)listener, null);
        Assert.assertThat((Object)rev, (Matcher)IsInstanceOf.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        Assert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Is.is((Object)devHash));
        Assert.assertThat((Object)rev.getHead().getName(), (Matcher)Is.is((Object)"dev"));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", devHash.substring(0, 10));
        rev = source.fetch(devHash.substring(0, 10), (TaskListener)listener, null);
        Assert.assertThat((Object)rev, (Matcher)IsInstanceOf.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        Assert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Is.is((Object)devHash));
        Assert.assertThat((Object)rev.getHead().getName(), (Matcher)Is.is((Object)"dev"));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", v1Hash);
        rev = source.fetch(v1Hash, (TaskListener)listener, null);
        Assert.assertThat((Object)rev, (Matcher)IsInstanceOf.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        Assert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Is.is((Object)v1Hash));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", v1Hash.substring(0, 10));
        rev = source.fetch(v1Hash.substring(0, 10), (TaskListener)listener, null);
        Assert.assertThat((Object)rev, (Matcher)IsInstanceOf.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        Assert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Is.is((Object)v1Hash));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", v2Hash);
        rev = source.fetch(v2Hash, (TaskListener)listener, null);
        Assert.assertThat((Object)rev, (Matcher)IsInstanceOf.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        Assert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Is.is((Object)v2Hash));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", v2Hash.substring(0, 10));
        rev = source.fetch(v2Hash.substring(0, 10), (TaskListener)listener, null);
        Assert.assertThat((Object)rev, (Matcher)IsInstanceOf.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        Assert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Is.is((Object)v2Hash));
        String v2Tag = "refs/tags/v2";
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", v2Tag);
        rev = source.fetch(v2Tag, (TaskListener)listener, null);
        Assert.assertThat((Object)rev, (Matcher)IsInstanceOf.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        Assert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Is.is((Object)v2Hash));
    }

    @Test
    public void retrievePrimaryHead_NotDuplicated() throws Exception {
        this.retrievePrimaryHead(false);
    }

    @Test
    public void retrievePrimaryHead_Duplicated() throws Exception {
        this.retrievePrimaryHead(true);
    }

    public void retrievePrimaryHead(boolean duplicatePrimary) throws Exception {
        boolean CLI_GIT_LESS_THAN_280;
        this.sampleRepo.init();
        this.sampleRepo.write("file.txt", "");
        this.sampleRepo.git("add", "file.txt");
        this.sampleRepo.git("commit", "--all", "--message=add-empty-file");
        this.sampleRepo.git("checkout", "-b", "new-primary");
        this.sampleRepo.write("file.txt", "content");
        this.sampleRepo.git("add", "file.txt");
        this.sampleRepo.git("commit", "--all", "--message=add-file");
        if (duplicatePrimary) {
            this.sampleRepo.git("checkout", "-b", "new-primary-duplicate", "new-primary");
        }
        this.sampleRepo.git("checkout", "master");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.git("symbolic-ref", "HEAD", "refs/heads/new-primary");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        ActionableSCMSourceOwner owner = (ActionableSCMSourceOwner)((Object)Mockito.mock(ActionableSCMSourceOwner.class));
        Mockito.when((Object)owner.getSCMSource(source.getId())).thenReturn((Object)source);
        Mockito.when((Object)owner.getSCMSources()).thenReturn(Collections.singletonList(source));
        source.setOwner((SCMSourceOwner)owner);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        TreeMap<String, SCMHead> headByName = new TreeMap<String, SCMHead>();
        for (SCMHead h : source.fetch((TaskListener)listener)) {
            headByName.put(h.getName(), h);
        }
        if (duplicatePrimary) {
            Assert.assertThat(headByName.keySet(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"master", "dev", "new-primary", "new-primary-duplicate"}));
        } else {
            Assert.assertThat(headByName.keySet(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"master", "dev", "new-primary"}));
        }
        List actions = source.fetchActions(null, (TaskListener)listener);
        GitRemoteHeadRefAction refAction = null;
        for (Action a : actions) {
            if (!(a instanceof GitRemoteHeadRefAction)) continue;
            refAction = (GitRemoteHeadRefAction)a;
            break;
        }
        boolean bl = CLI_GIT_LESS_THAN_280 = !this.sampleRepo.gitVersionAtLeast(2, 8);
        if (duplicatePrimary && CLI_GIT_LESS_THAN_280) {
            Assert.assertThat((Object)refAction, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        } else {
            Assert.assertThat((Object)refAction, (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)refAction.getName(), (Matcher)Is.is((Object)"new-primary"));
            Mockito.when((Object)owner.getAction(GitRemoteHeadRefAction.class)).thenReturn((Object)refAction);
            Mockito.when((Object)owner.getActions(GitRemoteHeadRefAction.class)).thenReturn(Collections.singletonList(refAction));
            actions = source.fetchActions((SCMHead)headByName.get("new-primary"), null, (TaskListener)listener);
        }
        PrimaryInstanceMetadataAction primary = null;
        for (Action a : actions) {
            if (!(a instanceof PrimaryInstanceMetadataAction)) continue;
            primary = (PrimaryInstanceMetadataAction)a;
            break;
        }
        if (duplicatePrimary && CLI_GIT_LESS_THAN_280) {
            Assert.assertThat(primary, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        } else {
            Assert.assertThat(primary, (Matcher)IsNull.notNullValue());
        }
    }

    @Test
    public void retrieveRevision() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v2", (Object)this.fileAt("master", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertEquals((Object)"v3", (Object)this.fileAt("dev", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertEquals((Object)"v1", (Object)this.fileAt("v1", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertEquals((Object)"v1", (Object)this.fileAt(v1, (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertEquals((Object)"v1", (Object)this.fileAt(v1.substring(0, 7), (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertNull((Object)this.fileAt("nonexistent", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertNull((Object)this.fileAt("1234567", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertNull((Object)this.fileAt("", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertNull((Object)this.fileAt("\n", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertThat((Object)source.fetchRevisions((TaskListener)listener, null), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"master", "dev", "v1"}));
    }

    @Test
    public void retrieveRevision_nonHead() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v3", (Object)this.fileAt(v3, (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
    }

    @Test
    @Ignore(value="At least file:// protocol doesn't allow fetching unannounced commits")
    public void retrieveRevision_nonAdvertised() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v3", (Object)this.fileAt(v3, (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
    }

    @Test
    public void retrieveRevision_customRef() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("update-ref", "refs/custom/foo", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("refs/custom/foo")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v3", (Object)this.fileAt(v3, (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
    }

    @Test
    public void retrieveRevision_customRef_descendant() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        String v2 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        this.sampleRepo.git("update-ref", "refs/custom/foo", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD~2");
        String dev = this.sampleRepo.head();
        Assert.assertNotEquals((Object)dev, (Object)v3);
        Assert.assertEquals((Object)dev, (Object)v2);
        this.sampleRepo.write("file", "v5");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("refs/custom/*")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v3", (Object)this.fileAt(v3, (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
    }

    @Test
    public void retrieveRevision_customRef_abbrev_sha1() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("update-ref", "refs/custom/foo", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("refs/custom/foo")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v3", (Object)this.fileAt(v3.substring(0, 7), (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
    }

    @Test
    public void retrieveRevision_pr_refspec() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("update-ref", "refs/pull-requests/1/from", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("pull-requests/*/from")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v3", (Object)this.fileAt("pull-requests/1/from", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
    }

    @Test
    public void retrieveRevision_pr_local_refspec() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("update-ref", "refs/pull-requests/1/from", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("/pull-requests/*/from", "pr/@{1}")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v3", (Object)this.fileAt("pr/1", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
    }

    private String fileAt(String revision, Run<?, ?> run, SCMSource source, TaskListener listener) throws Exception {
        SCMRevision rev = source.fetch(revision, listener, null);
        if (rev == null) {
            return null;
        }
        FilePath ws = new FilePath(run.getRootDir()).child("ws" + ++this.wsCount);
        source.build(rev.getHead(), rev).checkout(run, (Launcher)new Launcher.LocalLauncher(listener), ws, listener, null, SCMRevisionState.NONE);
        return ws.child("file").readToString();
    }

    @Test
    public void fetchOtherRef() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("update-ref", "refs/custom/1", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("custom/*")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        SCMHeadObserver.Collector collector = (SCMHeadObserver.Collector)source.fetch(new SCMSourceCriteria(){

            public boolean isHead(@NonNull SCMSourceCriteria.Probe probe, @NonNull TaskListener listener) throws IOException {
                return true;
            }
        }, (SCMHeadObserver)new SCMHeadObserver.Collector(), (TaskListener)listener);
        Map result = collector.result();
        Assert.assertThat(result.entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        Assert.assertThat((Object)result, (Matcher)IsMapContaining.hasKey((Matcher)AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(GitRefSCMHead.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"custom-1"))})));
    }

    @Test
    public void fetchOtherRevisions() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("update-ref", "refs/custom/1", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("custom/*")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Set revisions = source.fetchRevisions((TaskListener)listener, null);
        Assert.assertThat((Object)revisions, (Matcher)IsCollectionWithSize.hasSize((int)4));
        Assert.assertThat((Object)revisions, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)"custom-1"), IsEqual.equalTo((Object)"v1"), IsEqual.equalTo((Object)"dev"), IsEqual.equalTo((Object)"master")}));
    }

    @Test
    public void pruneRemovesDeletedBranches() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("master-file", "master-content-" + UUID.randomUUID().toString());
        this.sampleRepo.git("add", "master-file");
        this.sampleRepo.git("commit", "--message=master-branch-commit-message");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("dev-file", "dev-content-" + UUID.randomUUID().toString());
        this.sampleRepo.git("add", "dev-file");
        this.sampleRepo.git("commit", "--message=dev-branch-commit-message");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2", "master");
        this.sampleRepo.write("dev2-file", "dev2-content-" + UUID.randomUUID().toString());
        this.sampleRepo.git("add", "dev2-file");
        this.sampleRepo.git("commit", "--message=dev2-branch-commit-message");
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_DEV2_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("branch", "-D", "dev");
        Assert.assertEquals((Object)"[GitBranchSCMHead{name='dev2', ref='refs/heads/dev2'}, GitBranchSCMHead{name='master', ref='refs/heads/master'}]", (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void testSpecificRevisionBuildChooser() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("master-file", "master-content-" + UUID.randomUUID().toString());
        this.sampleRepo.git("add", "master-file");
        this.sampleRepo.git("commit", "--message=master-branch-commit-message");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Collections.singletonList(new IgnoreOnPushNotificationTrait()));
        ArrayList<Object> extensions = new ArrayList<Object>();
        Assert.assertThat((Object)source.getExtensions(), (Matcher)Is.is((Matcher)IsEmptyCollection.empty()));
        LocalBranch localBranchExtension = new LocalBranch("**");
        extensions.add(localBranchExtension);
        source.setExtensions(extensions);
        Assert.assertThat((Object)source.getExtensions(), (Matcher)IsIterableContainingInOrder.contains((Matcher)AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LocalBranch.class), HasPropertyWithValue.hasProperty((String)"localBranch", (Matcher)Is.is((Object)"**"))})));
        SCMHead head = new SCMHead("master");
        AbstractGitSCMSource.SCMRevisionImpl revision = new AbstractGitSCMSource.SCMRevisionImpl(head, "beaded4deed2bed4feed2deaf78933d0f97a5a34");
        extensions.add(new IgnoreNotifyCommit());
        GitSCM scm = (GitSCM)source.build(head);
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Matcher[])new Matcher[]{AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LocalBranch.class), HasPropertyWithValue.hasProperty((String)"localBranch", (Matcher)Is.is((Object)"**"))}), IsInstanceOf.instanceOf(IgnoreNotifyCommit.class), IsInstanceOf.instanceOf(GitSCMSourceDefaults.class)}));
        GitSCM scmRevision = (GitSCM)source.build(head, (SCMRevision)revision);
        Assert.assertThat((Object)scmRevision.getExtensions(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Matcher[])new Matcher[]{AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LocalBranch.class), HasPropertyWithValue.hasProperty((String)"localBranch", (Matcher)Is.is((Object)"**"))}), IsInstanceOf.instanceOf(BuildChooserSetting.class), IsInstanceOf.instanceOf(IgnoreNotifyCommit.class), IsInstanceOf.instanceOf(GitSCMSourceDefaults.class)}));
    }

    @Test
    public void testCustomRemoteName() throws Exception {
        this.sampleRepo.init();
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "upstream", null, "*", "", true);
        SCMHead head = new SCMHead("master");
        GitSCM scm = (GitSCM)source.build(head);
        List configs = scm.getUserRemoteConfigs();
        Assert.assertEquals((long)1L, (long)configs.size());
        UserRemoteConfig config = (UserRemoteConfig)configs.get(0);
        Assert.assertEquals((Object)"upstream", (Object)config.getName());
        Assert.assertEquals((Object)"+refs/heads/*:refs/remotes/upstream/*", (Object)config.getRefspec());
    }

    @Test
    public void testCustomRefSpecs() throws Exception {
        this.sampleRepo.init();
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", null, "+refs/heads/*:refs/remotes/origin/*          +refs/merge-requests/*/head:refs/remotes/origin/merge-requests/*", "*", "", true);
        SCMHead head = new SCMHead("master");
        GitSCM scm = (GitSCM)source.build(head);
        List configs = scm.getUserRemoteConfigs();
        Assert.assertEquals((long)1L, (long)configs.size());
        UserRemoteConfig config = (UserRemoteConfig)configs.get(0);
        Assert.assertEquals((Object)"origin", (Object)config.getName());
        Assert.assertEquals((Object)"+refs/heads/*:refs/remotes/origin/* +refs/merge-requests/*/head:refs/remotes/origin/merge-requests/*", (Object)config.getRefspec());
    }

    @Test
    public void refLockEncounteredIfPruneTraitNotPresentOnNotFoundRetrieval() throws Exception {
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        this.createRefLockEnvironment((TaskListener)listener, source);
        try {
            source.fetch("v1.2", (TaskListener)listener, null);
        }
        catch (GitException e) {
            Assert.assertFalse((boolean)e.getMessage().contains("--prune"));
            return;
        }
        Assert.fail();
    }

    @Test
    public void refLockEncounteredIfPruneTraitNotPresentOnTagRetrieval() throws Exception {
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Collections.singletonList(new TagDiscoveryTrait()));
        this.createRefLockEnvironment((TaskListener)listener, source);
        try {
            source.fetch("v1.2", (TaskListener)listener, null);
        }
        catch (GitException e) {
            Assert.assertFalse((boolean)e.getMessage().contains("--prune"));
            return;
        }
        Assert.fail();
    }

    @Test
    public void refLockAvoidedIfPruneTraitPresentOnNotFoundRetrieval() throws Exception {
        Assume.assumeTrue((boolean)this.sampleRepo.gitVersionAtLeast(1, 9, 0));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new TagDiscoveryTrait(), new PruneStaleBranchTrait()));
        this.createRefLockEnvironment((TaskListener)listener, source);
        source.fetch("v1.2", (TaskListener)listener, null);
        Assert.assertEquals((Object)"[SCMHead{'v1.2'}]", (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void refLockAvoidedIfPruneTraitPresentOnTagRetrieval() throws Exception {
        Assume.assumeTrue((boolean)this.sampleRepo.gitVersionAtLeast(1, 9, 0));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new TagDiscoveryTrait(), new PruneStaleBranchTrait()));
        this.createRefLockEnvironment((TaskListener)listener, source);
        source.fetch("v1.2", (TaskListener)listener, null);
        Assert.assertEquals((Object)"[SCMHead{'v1.2'}]", (Object)source.fetch((TaskListener)listener).toString());
    }

    private void createRefLockEnvironment(TaskListener listener, GitSCMSource source) throws Exception {
        String branch = "prune";
        String branchRefLock = "prune/prune";
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", branch);
        this.sampleRepo.git("push", "--set-upstream", source.getRemote(), branch);
        source.fetch("v1.2", listener, null);
        this.sampleRepo.git("checkout", "master");
        this.sampleRepo.git("push", source.getRemote(), "--delete", branch);
        this.sampleRepo.git("checkout", "-b", branchRefLock);
        this.sampleRepo.git("push", "--set-upstream", source.getRemote(), branchRefLock);
        this.sampleRepo.git("tag", "v1.2");
        this.sampleRepo.git("push", source.getRemote(), "v1.2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void when_commits_added_during_discovery_we_do_not_crash() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        System.setProperty(Git.class.getName() + ".mockClient", MockGitClient.class.getName());
        sharedSampleRepo = this.sampleRepo;
        try {
            GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
            source.setTraits(Arrays.asList(new BranchDiscoveryTrait()));
            StreamTaskListener listener = StreamTaskListener.fromStderr();
            SCMHeadObserver.Collector c = (SCMHeadObserver.Collector)source.fetch(new SCMSourceCriteria(){

                public boolean isHead(@NonNull SCMSourceCriteria.Probe probe, @NonNull TaskListener listener) throws IOException {
                    return true;
                }
            }, (SCMHeadObserver)new SCMHeadObserver.Collector(), (TaskListener)listener);
            Assert.assertThat(c.result().keySet(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"master")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"dev"))}));
        }
        catch (MissingObjectException me) {
            Assert.fail((String)"Not supposed to get MissingObjectException");
        }
        finally {
            System.clearProperty(Git.class.getName() + ".mockClient");
            sharedSampleRepo = null;
        }
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    public static class MockGitClient
    extends TestJGitAPIImpl {
        final String exe;
        final EnvVars env;

        public MockGitClient(String exe, EnvVars env, File workspace, TaskListener listener) {
            super(workspace, listener);
            this.exe = exe;
            this.env = env;
        }

        public Map<String, ObjectId> getRemoteReferences(String url, String pattern, boolean headsOnly, boolean tagsOnly) throws GitException, InterruptedException {
            Map remoteReferences = super.getRemoteReferences(url, pattern, headsOnly, tagsOnly);
            try {
                sharedSampleRepo.write("file2", "New");
                sharedSampleRepo.git("add", "file2");
                sharedSampleRepo.git("commit", "--all", "--message=inbetween");
            }
            catch (Exception e) {
                throw new GitException("Sneaking in something didn't work", (Throwable)e);
            }
            return remoteReferences;
        }

        public FetchCommand fetch_() {
            final FetchCommand fetchCommand = super.fetch_();
            return new FetchCommand(){

                public FetchCommand from(URIish urIish, List<RefSpec> list) {
                    fetchCommand.from(urIish, list);
                    return this;
                }

                public FetchCommand prune() {
                    fetchCommand.prune(true);
                    return this;
                }

                public FetchCommand prune(boolean b) {
                    fetchCommand.prune(b);
                    return this;
                }

                public FetchCommand shallow(boolean b) {
                    fetchCommand.shallow(b);
                    return this;
                }

                public FetchCommand timeout(Integer integer) {
                    fetchCommand.timeout(integer);
                    return this;
                }

                public FetchCommand tags(boolean b) {
                    fetchCommand.tags(b);
                    return this;
                }

                public FetchCommand depth(Integer integer) {
                    fetchCommand.depth(integer);
                    return this;
                }

                public void execute() throws GitException, InterruptedException {
                    fetchCommand.execute();
                    try {
                        sharedSampleRepo.write("file3", "New");
                        sharedSampleRepo.git("add", "file3");
                        sharedSampleRepo.git("commit", "--all", "--message=inbetween");
                    }
                    catch (Exception e) {
                        throw new GitException((Throwable)e);
                    }
                }
            };
        }
    }

    public static abstract class ActionableSCMSourceOwner
    extends Actionable
    implements SCMSourceOwner {
    }
}

