/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.plugins.git.GitSCM;
import hudson.plugins.git.browser.AssemblaWeb;
import hudson.plugins.git.browser.BitbucketWeb;
import hudson.plugins.git.browser.CGit;
import hudson.plugins.git.browser.FisheyeGitRepositoryBrowser;
import hudson.plugins.git.browser.GitBlitRepositoryBrowser;
import hudson.plugins.git.browser.GitLab;
import hudson.plugins.git.browser.GitList;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GitWeb;
import hudson.plugins.git.browser.GithubWeb;
import hudson.plugins.git.browser.Gitiles;
import hudson.plugins.git.browser.GitoriousWeb;
import hudson.plugins.git.browser.GogsGit;
import hudson.plugins.git.browser.KilnGit;
import hudson.plugins.git.browser.Phabricator;
import hudson.plugins.git.browser.RedmineWeb;
import hudson.plugins.git.browser.RhodeCode;
import hudson.plugins.git.browser.Stash;
import hudson.plugins.git.browser.TFS2013GitRepositoryBrowser;
import hudson.plugins.git.browser.ViewGitWeb;
import hudson.scm.SCM;
import io.jenkins.plugins.casc.misc.RoundTripAbstractTest;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.beans.HasPropertyWithValue;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.jenkinsci.plugins.workflow.libs.GlobalLibraries;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.SCMRetriever;
import org.junit.Assert;
import org.jvnet.hudson.test.RestartableJenkinsRule;

public class BrowsersJCasCCompatibilityTest
extends RoundTripAbstractTest {
    protected void assertConfiguredAsExpected(RestartableJenkinsRule restartableJenkinsRule, String s) {
        List libraries = GlobalLibraries.get().getLibraries();
        Assert.assertThat((Object)libraries, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withAssembla"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withFisheye"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withKiln"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withMic"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withBitbucket"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withCGit"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withGithub"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withGitiles"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withGitlab"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withGitlist"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withGitorious"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withGitweb"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withGogsgit"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withPhab"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withRedmine"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withRhodecode"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withStash"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withViewgit"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LibraryConfiguration.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"withGitlib"))})}));
        ArrayList<GitRepositoryBrowser> browsers = new ArrayList<GitRepositoryBrowser>();
        for (LibraryConfiguration library : libraries) {
            String errorMessage = String.format("Error checking library %s", library.getName());
            LibraryRetriever retriever = library.getRetriever();
            Assert.assertThat((String)errorMessage, (Object)retriever, (Matcher)IsInstanceOf.instanceOf(SCMRetriever.class));
            SCM scm = ((SCMRetriever)retriever).getScm();
            Assert.assertThat((String)errorMessage, (Object)scm, (Matcher)IsInstanceOf.instanceOf(GitSCM.class));
            GitSCM gitSCM = (GitSCM)scm;
            Assert.assertNotNull((String)errorMessage, (Object)gitSCM.getBrowser());
            browsers.add(gitSCM.getBrowser());
        }
        Assert.assertEquals((long)libraries.size(), (long)browsers.size());
        Assert.assertThat(browsers, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(AssemblaWeb.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.assembla"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(FisheyeGitRepositoryBrowser.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.fishEye/browse/foobar"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(KilnGit.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.kiln"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(TFS2013GitRepositoryBrowser.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.mic/_git/foobar/"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(BitbucketWeb.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.bitbucket"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(CGit.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.cgit"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(GitBlitRepositoryBrowser.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.gitlib")), HasPropertyWithValue.hasProperty((String)"projectName", (Matcher)IsEqual.equalTo((Object)"my_project"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(GithubWeb.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://github.com"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(Gitiles.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.gitiles"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(GitLab.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://gitlab.com"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(GitList.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.gitlist"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(GitoriousWeb.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.gitorious"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(GitWeb.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.gitweb"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(GogsGit.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.gogs"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(Phabricator.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.phabricator")), HasPropertyWithValue.hasProperty((String)"repo", (Matcher)IsEqual.equalTo((Object)"my_repository"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(RedmineWeb.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.redmineweb"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(RhodeCode.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.rhodecode"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(Stash.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.stash"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(ViewGitWeb.class), HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"http://url.viewgit")), HasPropertyWithValue.hasProperty((String)"projectName", (Matcher)IsEqual.equalTo((Object)"my_other_project"))})}));
    }

    protected String stringInLogExpected() {
        return "Setting class hudson.plugins.git.browser.GitBlitRepositoryBrowser.repoUrl = http://url.gitlib";
    }

    protected String configResource() {
        return "browsers-casc.yaml";
    }
}

