/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import io.jenkins.plugins.casc.misc.RoundTripAbstractTest;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jenkinsci.plugins.workflow.libs.GlobalLibraries;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.SCMRetriever;
import org.junit.Assert;
import org.jvnet.hudson.test.RestartableJenkinsRule;

public class GitJCasCCompatibilityTest
extends RoundTripAbstractTest {
    protected void assertConfiguredAsExpected(RestartableJenkinsRule restartableJenkinsRule, String s) {
        LibraryRetriever retriever = ((LibraryConfiguration)GlobalLibraries.get().getLibraries().get(0)).getRetriever();
        Assert.assertThat((Object)retriever, (Matcher)CoreMatchers.instanceOf(SCMRetriever.class));
        SCM scm = ((SCMRetriever)retriever).getScm();
        Assert.assertThat((Object)scm, (Matcher)CoreMatchers.instanceOf(GitSCM.class));
        Collection submodulesConfig = ((GitSCM)scm).getSubmoduleCfg();
        Assert.assertThat((Object)submodulesConfig.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)submodulesConfig.stream().anyMatch(m -> m.getSubmoduleName().equals("submodule-1")));
        Assert.assertTrue((boolean)submodulesConfig.stream().anyMatch(m -> m.getSubmoduleName().equals("submodule-2")));
        Assert.assertTrue((boolean)submodulesConfig.stream().anyMatch(m -> m.getBranchesString().equals("mybranch-1,mybranch-2")));
        Assert.assertTrue((boolean)submodulesConfig.stream().anyMatch(m -> m.getBranchesString().equals("mybranch-3,mybranch-4")));
    }

    protected String stringInLogExpected() {
        return "Setting class hudson.plugins.git.SubmoduleConfig.branches = [mybranch-3, mybranch-4]";
    }
}

