/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GithubWeb;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.impl.AuthorInChangelog;
import hudson.plugins.git.extensions.impl.BuildChooserSetting;
import hudson.plugins.git.extensions.impl.CleanCheckout;
import hudson.plugins.git.extensions.impl.CloneOption;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.InverseBuildChooser;
import java.util.Collections;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.GitSCMSourceDefaults;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class GitSCMBuilderTest {
    private GitSCMBuilder<?> instance = new GitSCMBuilder(new SCMHead("master"), null, "http://git.test/repo.git", null);

    @Test
    public void build() throws Exception {
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
    }

    @Test
    public void withRevision() throws Exception {
        this.instance.withExtension((GitSCMExtension)new BuildChooserSetting((BuildChooser)new InverseBuildChooser()));
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getExtensions().get(BuildChooserSetting.class), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)((BuildChooserSetting)scm.getExtensions().get(BuildChooserSetting.class)).getBuildChooser(), (Matcher)Matchers.instanceOf(InverseBuildChooser.class));
        this.instance.withRevision((SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl(this.instance.head(), "3f0b897057d8b43d3b9ff55e3fdefbb021493470"));
        scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions().get(BuildChooserSetting.class), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)((BuildChooserSetting)scm.getExtensions().get(BuildChooserSetting.class)).getBuildChooser(), (Matcher)Matchers.instanceOf(AbstractGitSCMSource.SpecificRevisionBuildChooser.class));
        Assert.assertThat((Object)((Revision)((BuildChooserSetting)scm.getExtensions().get(BuildChooserSetting.class)).getBuildChooser().getCandidateRevisions(false, null, (GitClient)null, null, null, null).iterator().next()).getSha1String(), (Matcher)Matchers.is((Object)"3f0b897057d8b43d3b9ff55e3fdefbb021493470"));
    }

    @Test
    public void withBrowser() throws Exception {
        this.instance.withBrowser((GitRepositoryBrowser)new GithubWeb("http://git.test/repo.git"));
        Assert.assertThat((Object)this.instance.browser(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(GithubWeb.class)));
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(GithubWeb.class)));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
    }

    @Test
    public void withCredentials() throws Exception {
        this.instance.withCredentials("example-id");
        Assert.assertThat((Object)this.instance.credentialsId(), (Matcher)Matchers.is((Object)"example-id"));
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Object)"example-id")))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
    }

    @Test
    public void withExtension() throws Exception {
        this.instance.withExtension((GitSCMExtension)new AuthorInChangelog());
        Assert.assertThat((Object)this.instance.extensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(AuthorInChangelog.class)));
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(AuthorInChangelog.class), Matchers.instanceOf(GitSCMSourceDefaults.class)}));
        this.instance.withExtension((GitSCMExtension)new LocalBranch("**"));
        Assert.assertThat((Object)this.instance.extensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(AuthorInChangelog.class), Matchers.allOf((Matcher)Matchers.instanceOf(LocalBranch.class), (Matcher)Matchers.hasProperty((String)"localBranch", (Matcher)Matchers.is((Object)"**")))}));
        scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(AuthorInChangelog.class), Matchers.instanceOf(GitSCMSourceDefaults.class), Matchers.allOf((Matcher)Matchers.instanceOf(LocalBranch.class), (Matcher)Matchers.hasProperty((String)"localBranch", (Matcher)Matchers.is((Object)"**")))}));
        this.instance.withExtension((GitSCMExtension)new LocalBranch("master"));
        Assert.assertThat((Object)this.instance.extensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(AuthorInChangelog.class), Matchers.allOf((Matcher)Matchers.instanceOf(LocalBranch.class), (Matcher)Matchers.hasProperty((String)"localBranch", (Matcher)Matchers.is((Object)"master")))}));
        scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(AuthorInChangelog.class), Matchers.instanceOf(GitSCMSourceDefaults.class), Matchers.allOf((Matcher)Matchers.instanceOf(LocalBranch.class), (Matcher)Matchers.hasProperty((String)"localBranch", (Matcher)Matchers.is((Object)"master")))}));
    }

    @Test
    public void withExtensions() throws Exception {
        this.instance.withExtensions(new GitSCMExtension[]{new AuthorInChangelog()});
        Assert.assertThat((Object)this.instance.extensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(AuthorInChangelog.class)));
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(AuthorInChangelog.class), Matchers.instanceOf(GitSCMSourceDefaults.class)}));
        this.instance.withExtensions(new GitSCMExtension[]{new CleanCheckout()});
        Assert.assertThat((Object)this.instance.extensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(AuthorInChangelog.class), Matchers.instanceOf(CleanCheckout.class)}));
        scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(AuthorInChangelog.class), Matchers.instanceOf(GitSCMSourceDefaults.class), Matchers.instanceOf(CleanCheckout.class)}));
        this.instance.withExtension((GitSCMExtension)new LocalBranch("**"));
        Assert.assertThat((Object)this.instance.extensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(AuthorInChangelog.class), Matchers.instanceOf(CleanCheckout.class), Matchers.allOf((Matcher)Matchers.instanceOf(LocalBranch.class), (Matcher)Matchers.hasProperty((String)"localBranch", (Matcher)Matchers.is((Object)"**")))}));
        scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(AuthorInChangelog.class), Matchers.instanceOf(GitSCMSourceDefaults.class), Matchers.instanceOf(CleanCheckout.class), Matchers.allOf((Matcher)Matchers.instanceOf(LocalBranch.class), (Matcher)Matchers.hasProperty((String)"localBranch", (Matcher)Matchers.is((Object)"**")))}));
        this.instance.withExtension((GitSCMExtension)new LocalBranch("master"));
        Assert.assertThat((Object)this.instance.extensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(AuthorInChangelog.class), Matchers.instanceOf(CleanCheckout.class), Matchers.allOf((Matcher)Matchers.instanceOf(LocalBranch.class), (Matcher)Matchers.hasProperty((String)"localBranch", (Matcher)Matchers.is((Object)"master")))}));
        scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(AuthorInChangelog.class), Matchers.instanceOf(GitSCMSourceDefaults.class), Matchers.instanceOf(CleanCheckout.class), Matchers.allOf((Matcher)Matchers.instanceOf(LocalBranch.class), (Matcher)Matchers.hasProperty((String)"localBranch", (Matcher)Matchers.is((Object)"master")))}));
    }

    @Test
    public void withGitTool() throws Exception {
        this.instance.withGitTool("git");
        Assert.assertThat((Object)this.instance.gitTool(), (Matcher)Matchers.is((Object)"git"));
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Object)"git"));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
    }

    @Test
    public void withRefSpecAndCloneOption() throws Exception {
        this.instance.withRefSpec("+refs/heads/master:refs/remotes/@{remote}/master");
        this.instance.withExtension((GitSCMExtension)new CloneOption(false, false, null, null));
        Assert.assertThat((Object)this.instance.refSpecs(), (Matcher)Matchers.contains((Object[])new String[]{"+refs/heads/master:refs/remotes/@{remote}/master"}));
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/master:refs/remotes/origin/master")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(CloneOption.class)));
    }

    @Test
    public void withRefSpec() throws Exception {
        this.instance.withRefSpec("+refs/heads/master:refs/remotes/@{remote}/master");
        Assert.assertThat((Object)this.instance.refSpecs(), (Matcher)Matchers.contains((Object[])new String[]{"+refs/heads/master:refs/remotes/@{remote}/master"}));
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/master:refs/remotes/origin/master")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
        this.instance.withRefSpec("+refs/heads/feature:refs/remotes/@{remote}/feature");
        Assert.assertThat((Object)this.instance.refSpecs(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"+refs/heads/master:refs/remotes/@{remote}/master", "+refs/heads/feature:refs/remotes/@{remote}/feature"}));
        scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/master:refs/remotes/origin/master +refs/heads/feature:refs/remotes/origin/feature")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))}));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
        this.instance.withRefSpec("+refs/heads/master:refs/remotes/@{remote}/master");
        Assert.assertThat((Object)this.instance.refSpecs(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"+refs/heads/master:refs/remotes/@{remote}/master", "+refs/heads/feature:refs/remotes/@{remote}/feature", "+refs/heads/master:refs/remotes/@{remote}/master"}));
        scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/master:refs/remotes/origin/master +refs/heads/feature:refs/remotes/origin/feature")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))}));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
        this.instance.withRefSpec("+refs/heads/master:refs/remotes/origin/master");
        Assert.assertThat((Object)this.instance.refSpecs(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"+refs/heads/master:refs/remotes/@{remote}/master", "+refs/heads/feature:refs/remotes/@{remote}/feature", "+refs/heads/master:refs/remotes/@{remote}/master", "+refs/heads/master:refs/remotes/origin/master"}));
        scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/master:refs/remotes/origin/master +refs/heads/feature:refs/remotes/origin/feature")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))}));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
    }

    @Test
    public void withRefSpecs() throws Exception {
        this.instance.withRefSpecs(Collections.singletonList("+refs/heads/master:refs/remotes/@{remote}/master"));
        Assert.assertThat((Object)this.instance.refSpecs(), (Matcher)Matchers.contains((Object[])new String[]{"+refs/heads/master:refs/remotes/@{remote}/master"}));
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/master:refs/remotes/origin/master")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
        this.instance.withRefSpecs(Collections.singletonList("+refs/heads/feature:refs/remotes/@{remote}/feature"));
        Assert.assertThat((Object)this.instance.refSpecs(), (Matcher)Matchers.contains((Object[])new String[]{"+refs/heads/master:refs/remotes/@{remote}/master", "+refs/heads/feature:refs/remotes/@{remote}/feature"}));
        scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/master:refs/remotes/origin/master +refs/heads/feature:refs/remotes/origin/feature")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
        this.instance.withRefSpecs(Collections.emptyList());
        Assert.assertThat((Object)this.instance.refSpecs(), (Matcher)Matchers.contains((Object[])new String[]{"+refs/heads/master:refs/remotes/@{remote}/master", "+refs/heads/feature:refs/remotes/@{remote}/feature"}));
        scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/master:refs/remotes/origin/master +refs/heads/feature:refs/remotes/origin/feature")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
    }

    @Test
    public void withoutRefSpecs() throws Exception {
        this.instance.withRefSpecs(Collections.singletonList("+refs/heads/feature:refs/remotes/@{remote}/feature"));
        Assume.assumeThat((Object)this.instance.refSpecs(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{"+refs/heads/*:refs/remotes/@{remote}/*"})));
        this.instance.withoutRefSpecs();
        Assert.assertThat((Object)this.instance.refSpecs(), (Matcher)Matchers.contains((Object[])new String[]{"+refs/heads/*:refs/remotes/@{remote}/*"}));
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
    }

    @Test
    public void withRemote() throws Exception {
        this.instance.withRemote("http://git.test/my-repo.git");
        Assert.assertThat((Object)this.instance.remote(), (Matcher)Matchers.is((Object)"http://git.test/my-repo.git"));
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/my-repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
    }

    @Test
    public void withRemoteName() throws Exception {
        this.instance.withRemoteName("my-remote");
        Assert.assertThat((Object)this.instance.remoteName(), (Matcher)Matchers.is((Object)"my-remote"));
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"my-remote")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/my-remote/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
    }

    @Test
    public void withAdditionalRemote() throws Exception {
        this.instance.withAdditionalRemote("upstream", "http://git.test/upstream.git", new String[]{"+refs/heads/master:refs/remotes/@{remote}/master"});
        Assert.assertThat((Object)this.instance.additionalRemoteNames(), (Matcher)Matchers.contains((Object[])new String[]{"upstream"}));
        Assert.assertThat((Object)this.instance.additionalRemote("upstream"), (Matcher)Matchers.is((Object)"http://git.test/upstream.git"));
        Assert.assertThat((Object)this.instance.additionalRemoteRefSpecs("upstream"), (Matcher)Matchers.contains((Object[])new String[]{"+refs/heads/master:refs/remotes/@{remote}/master"}));
        GitSCM scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))), Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/upstream.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"upstream")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/master:refs/remotes/upstream/master")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))}));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
        this.instance.withAdditionalRemote("production", "http://git.test/production.git", new String[0]);
        Assert.assertThat((Object)this.instance.additionalRemoteNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"upstream", "production"}));
        Assert.assertThat((Object)this.instance.additionalRemote("upstream"), (Matcher)Matchers.is((Object)"http://git.test/upstream.git"));
        Assert.assertThat((Object)this.instance.additionalRemoteRefSpecs("upstream"), (Matcher)Matchers.contains((Object[])new String[]{"+refs/heads/master:refs/remotes/@{remote}/master"}));
        Assert.assertThat((Object)this.instance.additionalRemote("production"), (Matcher)Matchers.is((Object)"http://git.test/production.git"));
        Assert.assertThat((Object)this.instance.additionalRemoteRefSpecs("production"), (Matcher)Matchers.contains((Object[])new String[]{"+refs/heads/*:refs/remotes/@{remote}/*"}));
        scm = this.instance.build();
        Assert.assertThat((Object)scm.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getUserRemoteConfigs(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/repo.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"origin")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))), Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/upstream.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"upstream")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/master:refs/remotes/upstream/master")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))), Matchers.allOf((Matcher)Matchers.instanceOf(UserRemoteConfig.class), (Matcher)Matchers.hasProperty((String)"url", (Matcher)Matchers.is((Object)"http://git.test/production.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"production")), (Matcher)Matchers.hasProperty((String)"refspec", (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/production/*")), (Matcher)Matchers.hasProperty((String)"credentialsId", (Matcher)Matchers.is((Matcher)Matchers.nullValue())))}));
        Assert.assertThat((Object)scm.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)scm.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(GitSCMSourceDefaults.class)));
    }
}

