/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.plugins.git.browser.BitbucketWeb;
import hudson.plugins.git.extensions.impl.AuthorInChangelog;
import hudson.plugins.git.extensions.impl.CheckoutOption;
import hudson.plugins.git.extensions.impl.CleanBeforeCheckout;
import hudson.plugins.git.extensions.impl.CleanCheckout;
import hudson.plugins.git.extensions.impl.CloneOption;
import hudson.plugins.git.extensions.impl.GitLFSPull;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.plugins.git.extensions.impl.PruneStaleBranch;
import hudson.plugins.git.extensions.impl.SparseCheckoutPaths;
import hudson.plugins.git.extensions.impl.SubmoduleOption;
import hudson.plugins.git.extensions.impl.UserIdentity;
import hudson.plugins.git.extensions.impl.WipeWorkspace;
import java.util.Collections;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.traits.AuthorInChangelogTrait;
import jenkins.plugins.git.traits.BranchDiscoveryTrait;
import jenkins.plugins.git.traits.CheckoutOptionTrait;
import jenkins.plugins.git.traits.CleanAfterCheckoutTrait;
import jenkins.plugins.git.traits.CleanBeforeCheckoutTrait;
import jenkins.plugins.git.traits.CloneOptionTrait;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.plugins.git.traits.GitLFSPullTrait;
import jenkins.plugins.git.traits.IgnoreOnPushNotificationTrait;
import jenkins.plugins.git.traits.LocalBranchTrait;
import jenkins.plugins.git.traits.PruneStaleBranchTrait;
import jenkins.plugins.git.traits.RefSpecsSCMSourceTrait;
import jenkins.plugins.git.traits.RemoteNameSCMSourceTrait;
import jenkins.plugins.git.traits.SparseCheckoutPathsTrait;
import jenkins.plugins.git.traits.SubmoduleOptionTrait;
import jenkins.plugins.git.traits.UserIdentityTrait;
import jenkins.plugins.git.traits.WipeWorkspaceTrait;
import jenkins.scm.impl.trait.WildcardSCMHeadFilterTrait;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.jvnet.hudson.test.JenkinsRule;

public class GitSCMSourceTraitsTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();
    @Rule
    public TestName currentTestName = new TestName();

    private GitSCMSource load() {
        return this.load(this.currentTestName.getMethodName());
    }

    private GitSCMSource load(String dataSet) {
        return (GitSCMSource)Jenkins.XSTREAM2.fromXML(this.getClass().getResource(this.getClass().getSimpleName() + "/" + dataSet + ".xml"));
    }

    @Test
    public void modern() throws Exception {
        GitSCMSource instance = this.load();
        Assert.assertThat((Object)instance.getId(), (Matcher)Matchers.is((Object)"5b061c87-da5c-4d69-b9d5-b041d065c945"));
        Assert.assertThat((Object)instance.getRemote(), (Matcher)Matchers.is((Object)"git://git.test/example.git"));
        Assert.assertThat((Object)instance.getCredentialsId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)instance.getTraits(), (Matcher)Matchers.is(Collections.emptyList()));
    }

    @Test
    public void cleancheckout_v1_extension() {
        this.verifyCleanCheckoutTraits(false);
    }

    @Test
    public void cleancheckout_v1_trait() {
        this.verifyCleanCheckoutTraits(false);
    }

    @Test
    public void cleancheckout_v2_extension() {
        this.verifyCleanCheckoutTraits(true);
    }

    @Test
    public void cleancheckout_v2_trait() {
        this.verifyCleanCheckoutTraits(true);
    }

    private void verifyCleanCheckoutTraits(boolean deleteUntrackedNestedRepositories) {
        GitSCMSource instance = this.load();
        Assert.assertThat((Object)instance.getTraits(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(CleanBeforeCheckoutTrait.class), (Matcher)Matchers.hasProperty((String)"extension", (Matcher)Matchers.hasProperty((String)"deleteUntrackedNestedRepositories", (Matcher)Matchers.is((Object)deleteUntrackedNestedRepositories)))), Matchers.allOf((Matcher)Matchers.instanceOf(CleanAfterCheckoutTrait.class), (Matcher)Matchers.hasProperty((String)"extension", (Matcher)Matchers.hasProperty((String)"deleteUntrackedNestedRepositories", (Matcher)Matchers.is((Object)deleteUntrackedNestedRepositories))))}));
    }

    @Test
    public void pimpped_out() throws Exception {
        GitSCMSource instance = this.load();
        Assert.assertThat((Object)instance.getId(), (Matcher)Matchers.is((Object)"fd2380f8-d34f-48d5-8006-c34542bc4a89"));
        Assert.assertThat((Object)instance.getRemote(), (Matcher)Matchers.is((Object)"git://git.test/example.git"));
        Assert.assertThat((Object)instance.getCredentialsId(), (Matcher)Matchers.is((Object)"e4d8c11a-0d24-472f-b86b-4b017c160e9a"));
        Assert.assertThat((Object)instance.getTraits(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(BranchDiscoveryTrait.class), Matchers.allOf((Matcher)Matchers.instanceOf(WildcardSCMHeadFilterTrait.class), (Matcher)Matchers.hasProperty((String)"includes", (Matcher)Matchers.is((Object)"foo/*")), (Matcher)Matchers.hasProperty((String)"excludes", (Matcher)Matchers.is((Object)"bar/*"))), Matchers.allOf((Matcher)Matchers.instanceOf(CheckoutOptionTrait.class), (Matcher)Matchers.hasProperty((String)"extension", (Matcher)Matchers.hasProperty((String)"timeout", (Matcher)Matchers.is((Object)5)))), Matchers.allOf((Matcher)Matchers.instanceOf(CloneOptionTrait.class), (Matcher)Matchers.hasProperty((String)"extension", (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"shallow", (Matcher)Matchers.is((Object)true)), (Matcher)Matchers.hasProperty((String)"noTags", (Matcher)Matchers.is((Object)true)), (Matcher)Matchers.hasProperty((String)"reference", (Matcher)Matchers.is((Object)"origin/foo")), (Matcher)Matchers.hasProperty((String)"timeout", (Matcher)Matchers.is((Object)3)), (Matcher)Matchers.hasProperty((String)"depth", (Matcher)Matchers.is((Object)3))))), Matchers.allOf((Matcher)Matchers.instanceOf(SubmoduleOptionTrait.class), (Matcher)Matchers.hasProperty((String)"extension", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"disableSubmodules", (Matcher)Matchers.is((Object)true)), Matchers.hasProperty((String)"recursiveSubmodules", (Matcher)Matchers.is((Object)true)), Matchers.hasProperty((String)"trackingSubmodules", (Matcher)Matchers.is((Object)true)), Matchers.hasProperty((String)"reference", (Matcher)Matchers.is((Object)"origin/bar")), Matchers.hasProperty((String)"parentCredentials", (Matcher)Matchers.is((Object)true)), Matchers.hasProperty((String)"timeout", (Matcher)Matchers.is((Object)4)), Matchers.hasProperty((String)"shallow", (Matcher)Matchers.is((Object)true)), Matchers.hasProperty((String)"depth", (Matcher)Matchers.is((Object)3)), Matchers.hasProperty((String)"threads", (Matcher)Matchers.is((Object)4))}))), Matchers.allOf((Matcher)Matchers.instanceOf(LocalBranchTrait.class), (Matcher)Matchers.hasProperty((String)"extension", (Matcher)Matchers.hasProperty((String)"localBranch", (Matcher)Matchers.is((Object)"**")))), Matchers.allOf((Matcher)Matchers.instanceOf(CleanBeforeCheckoutTrait.class), (Matcher)Matchers.hasProperty((String)"extension", (Matcher)Matchers.hasProperty((String)"deleteUntrackedNestedRepositories", (Matcher)Matchers.is((Object)true)))), Matchers.allOf((Matcher)Matchers.instanceOf(CleanAfterCheckoutTrait.class), (Matcher)Matchers.hasProperty((String)"extension", (Matcher)Matchers.hasProperty((String)"deleteUntrackedNestedRepositories", (Matcher)Matchers.is((Object)true)))), Matchers.allOf((Matcher)Matchers.instanceOf(UserIdentityTrait.class), (Matcher)Matchers.hasProperty((String)"extension", (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"bob")), (Matcher)Matchers.hasProperty((String)"email", (Matcher)Matchers.is((Object)"bob@example.com"))))), Matchers.instanceOf(GitLFSPullTrait.class), Matchers.instanceOf(PruneStaleBranchTrait.class), Matchers.instanceOf(IgnoreOnPushNotificationTrait.class), Matchers.instanceOf(AuthorInChangelogTrait.class), Matchers.instanceOf(WipeWorkspaceTrait.class), Matchers.allOf((Matcher)Matchers.instanceOf(GitBrowserSCMSourceTrait.class), (Matcher)Matchers.hasProperty((String)"browser", (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(BitbucketWeb.class), (Matcher)Matchers.hasProperty((String)"repoUrl", (Matcher)Matchers.is((Object)"foo"))))), Matchers.allOf((Matcher)Matchers.instanceOf(SparseCheckoutPathsTrait.class), (Matcher)Matchers.hasProperty((String)"extension", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"sparseCheckoutPaths", (Matcher)Matchers.hasSize((int)2))})))}));
        Assert.assertThat((Object)instance.getIncludes(), (Matcher)Matchers.is((Object)"foo/*"));
        Assert.assertThat((Object)instance.getExcludes(), (Matcher)Matchers.is((Object)"bar/*"));
        Assert.assertThat((String)"We have trimmed the extension to only those that are supported on GitSCMSource", (Object)instance.getExtensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(CheckoutOption.class), (Matcher)Matchers.hasProperty((String)"timeout", (Matcher)Matchers.is((Object)5))), Matchers.allOf((Matcher)Matchers.instanceOf(CloneOption.class), (Matcher)Matchers.hasProperty((String)"shallow", (Matcher)Matchers.is((Object)true)), (Matcher)Matchers.hasProperty((String)"noTags", (Matcher)Matchers.is((Object)true)), (Matcher)Matchers.hasProperty((String)"reference", (Matcher)Matchers.is((Object)"origin/foo")), (Matcher)Matchers.hasProperty((String)"timeout", (Matcher)Matchers.is((Object)3)), (Matcher)Matchers.hasProperty((String)"depth", (Matcher)Matchers.is((Object)3))), Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceOf(SubmoduleOption.class), Matchers.hasProperty((String)"disableSubmodules", (Matcher)Matchers.is((Object)true)), Matchers.hasProperty((String)"recursiveSubmodules", (Matcher)Matchers.is((Object)true)), Matchers.hasProperty((String)"trackingSubmodules", (Matcher)Matchers.is((Object)true)), Matchers.hasProperty((String)"reference", (Matcher)Matchers.is((Object)"origin/bar")), Matchers.hasProperty((String)"parentCredentials", (Matcher)Matchers.is((Object)true)), Matchers.hasProperty((String)"timeout", (Matcher)Matchers.is((Object)4))}), Matchers.allOf((Matcher)Matchers.instanceOf(LocalBranch.class), (Matcher)Matchers.hasProperty((String)"localBranch", (Matcher)Matchers.is((Object)"**"))), Matchers.instanceOf(CleanCheckout.class), Matchers.instanceOf(CleanBeforeCheckout.class), Matchers.allOf((Matcher)Matchers.instanceOf(UserIdentity.class), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"bob")), (Matcher)Matchers.hasProperty((String)"email", (Matcher)Matchers.is((Object)"bob@example.com"))), Matchers.instanceOf(GitLFSPull.class), Matchers.instanceOf(PruneStaleBranch.class), Matchers.instanceOf(AuthorInChangelog.class), Matchers.instanceOf(WipeWorkspace.class), Matchers.allOf((Matcher)Matchers.instanceOf(SparseCheckoutPaths.class), (Matcher)Matchers.hasProperty((String)"sparseCheckoutPaths", (Matcher)Matchers.hasSize((int)2)))}));
        Assert.assertThat((Object)instance.getBrowser(), (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(BitbucketWeb.class), (Matcher)Matchers.hasProperty((String)"repoUrl", (Matcher)Matchers.is((Object)"foo"))));
        Assert.assertThat((Object)instance.isIgnoreOnPushNotifications(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)instance.getRemoteName(), (Matcher)Matchers.is((Object)"origin"));
        Assert.assertThat((Object)instance.getRawRefSpecs(), (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*"));
    }

    @Test
    public void given__modernCode__when__constructor__then__traitsEmpty() throws Exception {
        Assert.assertThat((Object)new GitSCMSource("git://git.test/example.git").getTraits(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void given__legacyCode__when__constructor__then__traitsContainLegacyDefaults1() throws Exception {
        GitSCMSource instance = new GitSCMSource("id", "git://git.test/example.git", null, "*", "", false);
        Assert.assertThat((Object)instance.getTraits(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(BranchDiscoveryTrait.class)));
        Assert.assertThat((Object)instance.isIgnoreOnPushNotifications(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)instance.getIncludes(), (Matcher)Matchers.is((Object)"*"));
        Assert.assertThat((Object)instance.getExcludes(), (Matcher)Matchers.is((Object)""));
        Assert.assertThat((Object)instance.getRemoteName(), (Matcher)Matchers.is((Object)"origin"));
        Assert.assertThat((Object)instance.getRawRefSpecs(), (Matcher)Matchers.is((Object)"+refs/heads/*:refs/remotes/origin/*"));
    }

    @Test
    public void given__legacyCode__when__constructor__then__traitsContainLegacyDefaults2() throws Exception {
        GitSCMSource instance = new GitSCMSource("id", "git://git.test/example.git", null, "*", "", true);
        Assert.assertThat((Object)instance.getTraits(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.instanceOf(BranchDiscoveryTrait.class), Matchers.instanceOf(IgnoreOnPushNotificationTrait.class)}));
        Assert.assertThat((Object)instance.isIgnoreOnPushNotifications(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void given__legacyCode__when__constructor__then__traitsContainLegacyDefaults3() throws Exception {
        GitSCMSource instance = new GitSCMSource("id", "git://git.test/example.git", null, "foo/*", "", false);
        Assert.assertThat((Object)instance.getTraits(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.instanceOf(BranchDiscoveryTrait.class), Matchers.allOf((Matcher)Matchers.instanceOf(WildcardSCMHeadFilterTrait.class), (Matcher)Matchers.hasProperty((String)"includes", (Matcher)Matchers.is((Object)"foo/*")), (Matcher)Matchers.hasProperty((String)"excludes", (Matcher)Matchers.is((Object)"")))}));
        Assert.assertThat((Object)instance.getIncludes(), (Matcher)Matchers.is((Object)"foo/*"));
        Assert.assertThat((Object)instance.getExcludes(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void given__legacyCode__when__constructor__then__traitsContainLegacyDefaults4() throws Exception {
        GitSCMSource instance = new GitSCMSource("id", "git://git.test/example.git", null, "", "foo/*", false);
        Assert.assertThat((Object)instance.getTraits(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.instanceOf(BranchDiscoveryTrait.class), Matchers.allOf((Matcher)Matchers.instanceOf(WildcardSCMHeadFilterTrait.class), (Matcher)Matchers.hasProperty((String)"includes", (Matcher)Matchers.is((Object)"*")), (Matcher)Matchers.hasProperty((String)"excludes", (Matcher)Matchers.is((Object)"foo/*")))}));
        Assert.assertThat((Object)instance.getIncludes(), (Matcher)Matchers.is((Object)"*"));
        Assert.assertThat((Object)instance.getExcludes(), (Matcher)Matchers.is((Object)"foo/*"));
    }

    @Test
    public void given__legacyCode__when__constructor__then__traitsContainLegacyDefaults5() throws Exception {
        GitSCMSource instance = new GitSCMSource("id", "git://git.test/example.git", null, "upstream", null, "*", "", false);
        Assert.assertThat((Object)instance.getTraits(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.instanceOf(BranchDiscoveryTrait.class), Matchers.allOf((Matcher)Matchers.instanceOf(RemoteNameSCMSourceTrait.class), (Matcher)Matchers.hasProperty((String)"remoteName", (Matcher)Matchers.is((Object)"upstream")))}));
        Assert.assertThat((Object)instance.getRemoteName(), (Matcher)Matchers.is((Object)"upstream"));
    }

    @Test
    public void given__legacyCode__when__constructor__then__traitsContainLegacyDefaults6() throws Exception {
        GitSCMSource instance = new GitSCMSource("id", "git://git.test/example.git", null, null, "refs/pulls/*:refs/upstream/*", "*", "", false);
        Assert.assertThat((Object)instance.getTraits(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.instanceOf(BranchDiscoveryTrait.class), Matchers.allOf((Matcher)Matchers.instanceOf(RefSpecsSCMSourceTrait.class), (Matcher)Matchers.hasProperty((String)"templates", (Matcher)Matchers.contains((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)"refs/pulls/*:refs/upstream/*")))))}));
        Assert.assertThat((Object)instance.getRawRefSpecs(), (Matcher)Matchers.is((Object)"refs/pulls/*:refs/upstream/*"));
    }
}

