/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GitWeb;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.search.Search;
import hudson.search.SearchIndex;
import hudson.security.ACL;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSCMTelescope;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.plugins.git.traits.GitToolSCMSourceTrait;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.acegisecurity.AccessDeniedException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class GitSCMTelescopeTest {
    private final StandardCredentials credentials = null;
    @ClassRule
    public static final GitSampleRepoRule READ_ONLY_REPO = new GitSampleRepoRule();
    private final String remote = READ_ONLY_REPO.fileUrl();
    private GitSCMTelescope telescope;

    @Before
    public void createTelescopeForRemote() {
        this.telescope = new GitSCMTelescopeImpl(this.remote);
    }

    @Test
    public void testOf_GitSCM() {
        GitSCM multiBranchSource = new GitSCM(this.remote);
        GitSCMTelescope telescopeOfMultiBranchSource = GitSCMTelescope.of((GitSCM)multiBranchSource);
        Assert.assertThat((Object)telescopeOfMultiBranchSource, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testOf_AbstractGitSCMSource() {
        AbstractGitSCMSourceImpl source = new AbstractGitSCMSourceImpl();
        GitSCMTelescope telescopeOfAbstractGitSCMSource = GitSCMTelescope.of((AbstractGitSCMSource)source);
        Assert.assertThat((Object)telescopeOfAbstractGitSCMSource, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSupports_StringFalse() {
        GitSCMTelescopeImpl telescopeWithoutRemote = new GitSCMTelescopeImpl();
        Assert.assertFalse((boolean)telescopeWithoutRemote.supports(this.remote));
    }

    @Test
    public void testSupports_String() {
        Assert.assertTrue((boolean)this.telescope.supports(this.remote));
    }

    @Test
    public void testValidate() throws Exception {
        this.telescope.validate(this.remote, this.credentials);
    }

    private GitSCM getSingleBranchSource(String repoUrl) {
        UserRemoteConfig remoteConfig = new UserRemoteConfig(repoUrl, "origin", "+refs/heads/master:refs/remotes/origin/master", null);
        ArrayList<UserRemoteConfig> remoteConfigList = new ArrayList<UserRemoteConfig>();
        remoteConfigList.add(remoteConfig);
        BranchSpec masterBranchSpec = new BranchSpec("master");
        ArrayList<BranchSpec> branchSpecList = new ArrayList<BranchSpec>();
        branchSpecList.add(masterBranchSpec);
        boolean doGenerateSubmoduleConfigurations = false;
        ArrayList submoduleCfg = new ArrayList();
        GitWeb browser = new GitWeb(repoUrl);
        String gitTool = "Default";
        List extensions = null;
        GitSCM singleBranchSource = new GitSCM(remoteConfigList, branchSpecList, Boolean.valueOf(doGenerateSubmoduleConfigurations), submoduleCfg, (GitRepositoryBrowser)browser, gitTool, extensions);
        return singleBranchSource;
    }

    @Test
    public void testSupports_SCM() throws Exception {
        GitSCM singleBranchSource = this.getSingleBranchSource(this.remote);
        Assert.assertTrue((boolean)this.telescope.supports((SCM)singleBranchSource));
    }

    @Test
    public void testSupports_SCMNullSCM() throws Exception {
        NullSCM nullSCM = new NullSCM();
        Assert.assertFalse((boolean)this.telescope.supports((SCM)nullSCM));
    }

    @Test
    public void testSupports_SCMMultiBranchSource() throws Exception {
        GitSCM multiBranchSource = new GitSCM(this.remote);
        Assert.assertFalse((boolean)this.telescope.supports((SCM)multiBranchSource));
    }

    @Test
    public void testSupports_SCMSource() {
        GitSCMSource source = new GitSCMSource(this.remote);
        SCMSourceOwnerImpl sourceOwner = new SCMSourceOwnerImpl();
        source.setOwner((SCMSourceOwner)sourceOwner);
        Assert.assertTrue((boolean)this.telescope.supports((SCMSource)source));
    }

    @Test
    public void testSupports_SCMSourceNoOwner() {
        GitSCMSource source = new GitSCMSource(this.remote);
        Assert.assertFalse((boolean)this.telescope.supports((SCMSource)source));
    }

    @Test
    public void testSupports_SCMSourceNullSource() {
        SCMSourceImpl source = new SCMSourceImpl();
        Assert.assertFalse((boolean)this.telescope.supports((SCMSource)source));
    }

    @Test
    public void testGetTimestamp_3args_1() throws Exception {
        String refOrHash = "master";
        Assert.assertThat((Object)this.telescope.getTimestamp(this.remote, this.credentials, refOrHash), (Matcher)Matchers.is((Object)12345L));
    }

    @Test
    public void testGetTimestamp_3args_2Tag() throws Exception {
        GitTagSCMHead head = new GitTagSCMHead("git-tag-name", 56789L);
        Assert.assertThat((Object)this.telescope.getTimestamp(this.remote, this.credentials, (SCMHead)head), (Matcher)Matchers.is((Object)12345L));
    }

    @Test
    public void testGetTimestamp_3args_2() throws Exception {
        SCMHead head = new SCMHead("git-tag-name");
        Assert.assertThat((Object)this.telescope.getTimestamp(this.remote, this.credentials, head), (Matcher)Matchers.is((Object)12345L));
    }

    @Test
    public void testGetDefaultTarget() throws Exception {
        Assert.assertThat((Object)this.telescope.getDefaultTarget(this.remote, null), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void testBuild_3args_1() throws Exception {
        GitSCMSource source = new GitSCMSource(this.remote);
        SCMSourceOwnerImpl sourceOwner = new SCMSourceOwnerImpl();
        source.setOwner((SCMSourceOwner)sourceOwner);
        SCMHead head = new SCMHead("some-name");
        String SHA1 = "0123456789abcdef0123456789abcdef01234567";
        AbstractGitSCMSource.SCMRevisionImpl rev = new AbstractGitSCMSource.SCMRevisionImpl(head, SHA1);
        SCMFileSystem fileSystem = this.telescope.build((SCMSource)source, head, (SCMRevision)rev);
        Assert.assertThat((Object)fileSystem.getRevision(), (Matcher)Matchers.is((Object)rev));
        Assert.assertThat((Object)fileSystem.isFixedRevision(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testBuild_3args_1NoOwner() throws Exception {
        GitSCMSource source = new GitSCMSource(this.remote);
        SCMHead head = new SCMHead("some-name");
        SCMRevision rev = null;
        Assert.assertThat((Object)this.telescope.build((SCMSource)source, head, rev), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testBuild_3args_2() throws Exception {
        ItemImpl owner = new ItemImpl();
        GitSCM scm = this.getSingleBranchSource(this.remote);
        SCMHead head = new SCMHead("some-name");
        String SHA1 = "0123456789abcdef0123456789abcdef01234567";
        AbstractGitSCMSource.SCMRevisionImpl rev = new AbstractGitSCMSource.SCMRevisionImpl(head, SHA1);
        SCMFileSystem fileSystem = this.telescope.build((Item)owner, (SCM)scm, (SCMRevision)rev);
        Assert.assertThat((Object)fileSystem.getRevision(), (Matcher)Matchers.is((Object)rev));
        Assert.assertThat((Object)fileSystem.isFixedRevision(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testBuild_4args() throws Exception {
        SCMHead head = new SCMHead("some-name");
        String SHA1 = "0123456789abcdef0123456789abcdef01234567";
        AbstractGitSCMSource.SCMRevisionImpl rev = new AbstractGitSCMSource.SCMRevisionImpl(head, SHA1);
        SCMFileSystem fileSystem = this.telescope.build(this.remote, this.credentials, head, (SCMRevision)rev);
        Assert.assertThat((Object)fileSystem, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)fileSystem.getRevision(), (Matcher)Matchers.is((Object)rev));
        Assert.assertThat((Object)fileSystem.isFixedRevision(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetRevision_3args_1() throws Exception {
        SCMHead head = new SCMHead("some-name");
        String SHA1 = "0123456789abcdef0123456789abcdef01234567";
        AbstractGitSCMSource.SCMRevisionImpl rev = new AbstractGitSCMSource.SCMRevisionImpl(head, SHA1);
        GitSCMTelescopeImpl telescopeWithRev = new GitSCMTelescopeImpl(this.remote, (SCMRevision)rev);
        String refOrHash = "master";
        Assert.assertThat((Object)telescopeWithRev.getRevision(this.remote, this.credentials, refOrHash), (Matcher)Matchers.is((Object)rev));
    }

    @Test
    public void testGetRevision_3args_2() throws Exception {
        GitTagSCMHead head = new GitTagSCMHead("git-tag-name", 56789L);
        String SHA1 = "0123456789abcdef0123456789abcdef01234567";
        AbstractGitSCMSource.SCMRevisionImpl rev = new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, SHA1);
        GitSCMTelescopeImpl telescopeWithRev = new GitSCMTelescopeImpl(this.remote, (SCMRevision)rev);
        Assert.assertThat((Object)telescopeWithRev.getRevision(this.remote, this.credentials, (SCMHead)head), (Matcher)Matchers.is((Object)rev));
    }

    @Test
    public void testGetRevisions_3args() throws Exception {
        HashSet referenceTypes = new HashSet();
        Iterable revisions = this.telescope.getRevisions(this.remote, this.credentials, referenceTypes);
        Assert.assertThat((Object)revisions, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertFalse((boolean)revisions.iterator().hasNext());
    }

    @Test
    public void testGetRevisions_3argsWithRev() throws Exception {
        HashSet referenceTypes = new HashSet();
        GitTagSCMHead head = new GitTagSCMHead("git-tag-name", 56789L);
        String SHA1 = "0123456789abcdef0123456789abcdef01234567";
        AbstractGitSCMSource.SCMRevisionImpl rev = new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, SHA1);
        GitSCMTelescopeImpl telescopeWithRev = new GitSCMTelescopeImpl(this.remote, (SCMRevision)rev);
        Iterable revisions = telescopeWithRev.getRevisions(this.remote, this.credentials, referenceTypes);
        Assert.assertThat((Object)revisions, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Iterator revIterator = revisions.iterator();
        Assert.assertThat(revIterator.next(), (Matcher)Matchers.is((Object)rev));
        Assert.assertFalse((boolean)revIterator.hasNext());
    }

    @Test
    public void testGetRevisions_String_StandardCredentials() throws Exception {
        String SHA1 = "0123456789abcdef0123456789abcdef01234567";
        GitTagSCMHead head = new GitTagSCMHead("git-tag-name", 56789L);
        AbstractGitSCMSource.SCMRevisionImpl rev = new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, SHA1);
        GitSCMTelescopeImpl telescopeWithRev = new GitSCMTelescopeImpl(this.remote, (SCMRevision)rev);
        Iterable revisions = telescopeWithRev.getRevisions(this.remote, this.credentials);
        Assert.assertThat((Object)revisions, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Iterator revIterator = revisions.iterator();
        Assert.assertThat(revIterator.next(), (Matcher)Matchers.is((Object)rev));
        Assert.assertFalse((boolean)revIterator.hasNext());
    }

    private static class SCMSourceOwnerImpl
    implements SCMSourceOwner {
        private SCMSourceOwnerImpl() {
        }

        public List<SCMSource> getSCMSources() {
            throw new UnsupportedOperationException("Not called.");
        }

        public SCMSource getSCMSource(String string) {
            throw new UnsupportedOperationException("Not called.");
        }

        public void onSCMSourceUpdated(SCMSource scms) {
            throw new UnsupportedOperationException("Not called.");
        }

        public SCMSourceCriteria getSCMSourceCriteria(SCMSource scms) {
            throw new UnsupportedOperationException("Not called.");
        }

        public ItemGroup<? extends Item> getParent() {
            throw new UnsupportedOperationException("Not called.");
        }

        public Collection<? extends Job> getAllJobs() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getName() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getFullName() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getDisplayName() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getFullDisplayName() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getRelativeNameFrom(ItemGroup ig) {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getRelativeNameFrom(Item item) {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getUrl() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getShortUrl() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getAbsoluteUrl() {
            throw new UnsupportedOperationException("Not called.");
        }

        public void onLoad(ItemGroup<? extends Item> ig, String string) throws IOException {
            throw new UnsupportedOperationException("Not called.");
        }

        public void onCopiedFrom(Item item) {
            throw new UnsupportedOperationException("Not called.");
        }

        public void onCreatedFromScratch() {
            throw new UnsupportedOperationException("Not called.");
        }

        public void save() throws IOException {
            throw new UnsupportedOperationException("Not called.");
        }

        public void delete() throws IOException, InterruptedException {
            throw new UnsupportedOperationException("Not called.");
        }

        public File getRootDir() {
            throw new UnsupportedOperationException("Not called.");
        }

        public Search getSearch() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getSearchName() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getSearchUrl() {
            throw new UnsupportedOperationException("Not called.");
        }

        public SearchIndex getSearchIndex() {
            throw new UnsupportedOperationException("Not called.");
        }

        public ACL getACL() {
            throw new UnsupportedOperationException("Not called.");
        }

        public void checkPermission(Permission prmsn) throws AccessDeniedException {
            throw new UnsupportedOperationException("Not called.");
        }

        public boolean hasPermission(Permission prmsn) {
            throw new UnsupportedOperationException("Not called.");
        }
    }

    private static class AbstractGitSCMSourceImpl
    extends AbstractGitSCMSource {
        public AbstractGitSCMSourceImpl() {
            this.setId("AbstractGitSCMSourceImpl-id");
        }

        @NonNull
        public List<SCMSourceTrait> getTraits() {
            return Collections.singletonList(new GitToolSCMSourceTrait("git-custom"){

                public SCMSourceTraitDescriptor getDescriptor() {
                    return new GitBrowserSCMSourceTrait.DescriptorImpl();
                }
            });
        }

        public String getCredentialsId() {
            return "";
        }

        public String getRemote() {
            return "";
        }

        public SCMSourceDescriptor getDescriptor() {
            return new DescriptorImpl();
        }

        public static class DescriptorImpl
        extends SCMSourceDescriptor {
            public String getDisplayName() {
                return null;
            }
        }
    }

    private static class GitSCMTelescopeImpl
    extends GitSCMTelescope {
        private final String allowedRemote;
        private final SCMRevision revision;
        private List<SCMRevision> revisionList = new ArrayList<SCMRevision>();

        public GitSCMTelescopeImpl(String allowedRemote, SCMRevision revision) {
            this.allowedRemote = allowedRemote;
            this.revision = revision;
            this.revisionList = new ArrayList<SCMRevision>();
            this.revisionList.add(this.revision);
        }

        public GitSCMTelescopeImpl(String allowedRemote) {
            this.allowedRemote = allowedRemote;
            this.revision = null;
            this.revisionList = new ArrayList<SCMRevision>();
        }

        public GitSCMTelescopeImpl() {
            this.allowedRemote = null;
            this.revision = null;
            this.revisionList = new ArrayList<SCMRevision>();
        }

        public boolean supports(String remote) {
            if (this.allowedRemote == null) {
                return false;
            }
            return this.allowedRemote.equals(remote);
        }

        public boolean supportsDescriptor(SCMDescriptor descriptor) {
            return false;
        }

        public boolean supportsDescriptor(SCMSourceDescriptor descriptor) {
            return false;
        }

        public void validate(String remote, StandardCredentials credentials) throws IOException, InterruptedException {
        }

        public SCMFileSystem build(String remote, StandardCredentials credentials, SCMHead head, SCMRevision rev) throws IOException, InterruptedException {
            GitClient client = null;
            AbstractGitSCMSource.SCMRevisionImpl myRev = null;
            if (rev != null) {
                String SHA1 = rev.toString();
                myRev = new AbstractGitSCMSource.SCMRevisionImpl(head, SHA1);
            }
            return new GitSCMFileSystem(client, remote, head.toString(), myRev);
        }

        public long getTimestamp(String remote, StandardCredentials credentials, String refOrHash) throws IOException, InterruptedException {
            return 12345L;
        }

        public SCMRevision getRevision(String remote, StandardCredentials credentials, String refOrHash) throws IOException, InterruptedException {
            return this.revision;
        }

        public Iterable<SCMRevision> getRevisions(String remote, StandardCredentials credentials, Set<GitSCMTelescope.ReferenceType> referenceTypes) throws IOException, InterruptedException {
            return this.revisionList;
        }

        public String getDefaultTarget(String remote, StandardCredentials credentials) throws IOException, InterruptedException {
            return "";
        }
    }

    private static class SCMSourceImpl
    extends SCMSource {
        protected void retrieve(SCMSourceCriteria scmsc, SCMHeadObserver scmho, SCMHeadEvent<?> scmhe, TaskListener tl) throws IOException, InterruptedException {
            throw new UnsupportedOperationException("Not called.");
        }

        public SCM build(SCMHead scmh, SCMRevision scmr) {
            throw new UnsupportedOperationException("Not called.");
        }
    }

    private static class ItemImpl
    implements Item {
        public ItemGroup<? extends Item> getParent() {
            throw new UnsupportedOperationException("Not called.");
        }

        public Collection<? extends Job> getAllJobs() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getName() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getFullName() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getDisplayName() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getFullDisplayName() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getRelativeNameFrom(ItemGroup ig) {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getRelativeNameFrom(Item item) {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getUrl() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getShortUrl() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getAbsoluteUrl() {
            throw new UnsupportedOperationException("Not called.");
        }

        public void onLoad(ItemGroup<? extends Item> ig, String string) throws IOException {
            throw new UnsupportedOperationException("Not called.");
        }

        public void onCopiedFrom(Item item) {
            throw new UnsupportedOperationException("Not called.");
        }

        public void onCreatedFromScratch() {
            throw new UnsupportedOperationException("Not called.");
        }

        public void save() throws IOException {
            throw new UnsupportedOperationException("Not called.");
        }

        public void delete() throws IOException, InterruptedException {
            throw new UnsupportedOperationException("Not called.");
        }

        public File getRootDir() {
            throw new UnsupportedOperationException("Not called.");
        }

        public Search getSearch() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getSearchName() {
            throw new UnsupportedOperationException("Not called.");
        }

        public String getSearchUrl() {
            throw new UnsupportedOperationException("Not called.");
        }

        public SearchIndex getSearchIndex() {
            throw new UnsupportedOperationException("Not called.");
        }

        public ACL getACL() {
            throw new UnsupportedOperationException("Not called.");
        }

        public void checkPermission(Permission prmsn) throws AccessDeniedException {
            throw new UnsupportedOperationException("Not called.");
        }

        public boolean hasPermission(Permission prmsn) {
            throw new UnsupportedOperationException("Not called.");
        }
    }
}

