/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gittagmessage;

import hudson.Functions;
import hudson.Util;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Run;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import hudson.tasks.BatchFile;
import hudson.tasks.Builder;
import hudson.tasks.Shell;
import java.util.Collections;
import org.jenkinsci.plugins.gittagmessage.AbstractGitTagMessageExtensionTest;
import org.jenkinsci.plugins.gittagmessage.GitTagMessageExtension;

public class GitTagMessageExtensionTest
extends AbstractGitTagMessageExtensionTest<FreeStyleProject, FreeStyleBuild> {
    @Override
    protected FreeStyleProject configureGitTagMessageJob(String refSpec, String branchSpec, boolean useMostRecentTag) throws Exception {
        GitTagMessageExtension extension = new GitTagMessageExtension();
        extension.setUseMostRecentTag(useMostRecentTag);
        UserRemoteConfig remote = new UserRemoteConfig(this.repoDir.getRoot().getAbsolutePath(), "origin", refSpec, null);
        GitSCM scm = new GitSCM(Collections.singletonList(remote), Collections.singletonList(new BranchSpec(branchSpec)), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.singletonList(extension));
        FreeStyleProject job = this.jenkins.createFreeStyleProject();
        job.getBuildersList().add((Object)GitTagMessageExtensionTest.createEnvEchoBuilder("tag", "GIT_TAG_NAME"));
        job.getBuildersList().add((Object)GitTagMessageExtensionTest.createEnvEchoBuilder("msg", "GIT_TAG_MESSAGE"));
        job.setScm((SCM)scm);
        return job;
    }

    @Override
    protected void assertBuildEnvironment(FreeStyleBuild build, String expectedName, String expectedMessage) throws Exception {
        this.jenkins.assertLogContains(String.format("tag='%s'", Util.fixNull((String)expectedName)), (Run)build);
        this.jenkins.assertLogContains(String.format("msg='%s'", Util.fixNull((String)expectedMessage)), (Run)build);
    }

    private static Builder createEnvEchoBuilder(String key, String envVarName) {
        if (Functions.isWindows()) {
            return new BatchFile(String.format("echo %s='%%%s%%'", key, envVarName));
        }
        return new Shell(String.format("echo \"%s='${%s}'\"", key, envVarName));
    }
}

