/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class BitbucketServer
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public BitbucketServer(String repoUrl) {
        super(repoUrl);
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "commits/" + changeSet.getId());
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT || path.getSrc() == null || path.getDst() == null || path.getChangeSet().getParentCommit() == null) {
            return null;
        }
        return this.getDiffLinkRegardlessOfEditType(path);
    }

    private URL getDiffLinkRegardlessOfEditType(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        String pathAsString = path.getPath();
        return new URL(this.getChangeSetLink(changeSet), "#" + pathAsString);
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        String pathAsString = path.getPath();
        URL url = this.getUrl();
        return BitbucketServer.encodeURL(new URL(url, url.getPath() + "browse/" + pathAsString));
    }

    @Extension
    @Symbol(value={"bitbucketServer"})
    public static class BitbucketServerDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @NonNull
        public String getDisplayName() {
            return "bitbucketserver";
        }

        public BitbucketServer newInstance(@NonNull StaplerRequest2 req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            return (BitbucketServer)((Object)req.bindJSON(BitbucketServer.class, jsonObject));
        }
    }
}

