/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.credentials.oauth;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.NameWith;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainRestrictedCredentials;
import com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.jenkins.plugins.credentials.oauth.AbstractGoogleRobotCredentialsDescriptor;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2ScopeRequirement;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2ScopeSpecification;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotMetadataCredentialsModule;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotNameProvider;
import com.google.jenkins.plugins.credentials.oauth.Messages;
import com.google.jenkins.plugins.util.ExecutorException;
import hudson.Extension;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.annotation.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;

@NameWith(value=GoogleRobotNameProvider.class, priority=50)
public final class GoogleRobotMetadataCredentials
extends GoogleRobotCredentials
implements DomainRestrictedCredentials {
    @Nullable
    private transient Domain metadataScopes;
    private static final String IDENTITY_PATH = "/instance/service-accounts/default/email";
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GoogleRobotMetadataCredentials(String projectId, @Nullable GoogleRobotMetadataCredentialsModule module) throws Exception {
        super(projectId, module);
    }

    @Override
    public GoogleRobotMetadataCredentialsModule getModule() {
        return (GoogleRobotMetadataCredentialsModule)super.getModule();
    }

    public synchronized boolean matches(List<DomainRequirement> requirements) {
        if (this.metadataScopes == null) {
            this.metadataScopes = new Domain("metadata", "", (List)ImmutableList.of((Object)((Object)new GoogleOAuth2ScopeSpecification(this.getDescriptor().defaultScopes()))));
        }
        return this.metadataScopes.test(requirements);
    }

    public String getUsername() {
        try {
            return this.getModule().getMetadataReader().readMetadata(IDENTITY_PATH);
        }
        catch (ExecutorException e) {
            throw new IllegalStateException(Messages.GoogleRobotMetadataCredentials_DefaultIdentityError(), e);
        }
        catch (IOException e) {
            throw new IllegalStateException(Messages.GoogleRobotMetadataCredentials_DefaultIdentityError(), e);
        }
    }

    public CredentialsScope getScope() {
        return CredentialsScope.GLOBAL;
    }

    public ComputeCredential getGoogleCredential(GoogleOAuth2ScopeRequirement requirement) throws GeneralSecurityException {
        return new ComputeCredential(this.getModule().getHttpTransport(), this.getModule().getJsonFactory());
    }

    @Override
    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    public static class Descriptor
    extends AbstractGoogleRobotCredentialsDescriptor {
        @VisibleForTesting
        static boolean disableForTesting = false;
        private static final String PROJECT_ID_PATH = "/project/project-id";
        private static final String SCOPES_PATH = "/instance/service-accounts/default/scopes";

        @Extension
        @Nullable
        public static Descriptor metadataDescriptor() throws IOException {
            if (disableForTesting) {
                return null;
            }
            GoogleRobotMetadataCredentialsModule defaultModule = new GoogleRobotMetadataCredentialsModule();
            if (defaultModule.getMetadataReader().hasMetadata()) {
                return new Descriptor(defaultModule);
            }
            return null;
        }

        @VisibleForTesting
        Descriptor(GoogleRobotMetadataCredentialsModule module) {
            super(GoogleRobotMetadataCredentials.class, module);
        }

        public String getDisplayName() {
            return Messages.GoogleRobotMetadataCredentials_DisplayName();
        }

        @Override
        public GoogleRobotMetadataCredentialsModule getModule() {
            return (GoogleRobotMetadataCredentialsModule)super.getModule();
        }

        @Nullable
        public String defaultProject() {
            try {
                return this.getModule().getMetadataReader().readMetadata(PROJECT_ID_PATH);
            }
            catch (ExecutorException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }

        public List<String> defaultScopes() {
            try {
                String scopes = this.getModule().getMetadataReader().readMetadata(SCOPES_PATH);
                return Lists.newArrayList((Iterable)Splitter.on((char)'\n').trimResults().omitEmptyStrings().split((CharSequence)scopes));
            }
            catch (ExecutorException e) {
                return ImmutableList.of();
            }
            catch (IOException e) {
                return ImmutableList.of();
            }
        }
    }
}

