/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.credentials.oauth;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.NameWith;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.credentials.oauth.AbstractGoogleRobotCredentialsDescriptor;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2ScopeRequirement;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentialsModule;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotNameProvider;
import com.google.jenkins.plugins.credentials.oauth.JsonServiceAccountConfig;
import com.google.jenkins.plugins.credentials.oauth.LegacyJsonKey;
import com.google.jenkins.plugins.credentials.oauth.Messages;
import com.google.jenkins.plugins.credentials.oauth.P12ServiceAccountConfig;
import com.google.jenkins.plugins.credentials.oauth.ServiceAccountConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.codehaus.jackson.JsonParseException;
import org.kohsuke.stapler.DataBoundConstructor;

@NameWith(value=GoogleRobotNameProvider.class, priority=50)
public final class GoogleRobotPrivateKeyCredentials
extends GoogleRobotCredentials {
    private static final long serialVersionUID = -6768343254941345944L;
    private static final Logger LOGGER = Logger.getLogger(GoogleRobotPrivateKeyCredentials.class.getSimpleName());
    private ServiceAccountConfig serviceAccountConfig;
    @Deprecated
    private transient String secretsFile;
    @Deprecated
    private transient String p12File;

    @DataBoundConstructor
    public GoogleRobotPrivateKeyCredentials(String projectId, ServiceAccountConfig serviceAccountConfig, @Nullable GoogleRobotCredentialsModule module) throws Exception {
        super(projectId, module);
        this.serviceAccountConfig = serviceAccountConfig;
    }

    public Object readResolve() {
        if (this.serviceAccountConfig == null) {
            String clientEmail = this.getClientEmailFromSecretsFileAndLogErrors();
            this.serviceAccountConfig = new P12ServiceAccountConfig(clientEmail, null, this.p12File);
        }
        return this;
    }

    private String getClientEmailFromSecretsFileAndLogErrors() {
        try {
            return this.getClientEmailFromSecretsFile();
        }
        catch (MissingSecretsFileException e) {
            LOGGER.log(Level.WARNING, String.format("SecretsFile is not set. Failed to set Service Account E-Mail Address on upgraded Credentials with Project Id '%s'.", this.getProjectId()));
        }
        catch (SecretsFileNotFoundException e) {
            LOGGER.log(Level.WARNING, String.format("SecretsFile could not be found. Failed to set Service Account E-Mail Address on upgraded Credentials with Project Id '%s'.", this.getProjectId()));
        }
        catch (InvalidSecretsFileException e) {
            LOGGER.log(Level.WARNING, String.format("Invalid SecretsFile format. Failed to set Service Account E-Mail Address on upgraded Credentials with Project Id '%s'.", this.getProjectId()));
        }
        return null;
    }

    private String getClientEmailFromSecretsFile() throws MissingSecretsFileException, SecretsFileNotFoundException, InvalidSecretsFileException {
        LegacyJsonKey legacyJsonKey;
        if (this.secretsFile == null) {
            throw new MissingSecretsFileException();
        }
        try {
            legacyJsonKey = LegacyJsonKey.load(this.getModule().getJsonFactory(), new FileInputStream(this.secretsFile));
        }
        catch (JsonParseException e) {
            throw new InvalidSecretsFileException(e);
        }
        catch (IOException e) {
            throw new SecretsFileNotFoundException(e);
        }
        LegacyJsonKey.Details web = legacyJsonKey.getWeb();
        if (web == null) {
            throw new InvalidSecretsFileException();
        }
        String clientEmail = web.getClientEmail();
        if (clientEmail == null) {
            throw new InvalidSecretsFileException();
        }
        return clientEmail;
    }

    public static List<ServiceAccountConfig.Descriptor> getServiceAccountConfigDescriptors() {
        Jenkins instance = Jenkins.getInstance();
        return ImmutableList.of((Object)((Object)((ServiceAccountConfig.Descriptor)instance.getDescriptorOrDie(JsonServiceAccountConfig.class))), (Object)((Object)((ServiceAccountConfig.Descriptor)instance.getDescriptorOrDie(P12ServiceAccountConfig.class))));
    }

    @NonNull
    public String getUsername() throws KeyTypeNotSetException, AccountIdNotSetException {
        if (this.serviceAccountConfig == null) {
            throw new KeyTypeNotSetException();
        }
        String accountId = this.serviceAccountConfig.getAccountId();
        if (accountId == null) {
            throw new AccountIdNotSetException();
        }
        return accountId;
    }

    public static String getHelpFile() {
        return Jenkins.getInstance().getDescriptorOrDie(GoogleRobotPrivateKeyCredentials.class).getHelpFile("credentials");
    }

    public CredentialsScope getScope() {
        return CredentialsScope.GLOBAL;
    }

    public GoogleCredential getGoogleCredential(GoogleOAuth2ScopeRequirement requirement) throws KeyTypeNotSetException, AccountIdNotSetException, PrivateKeyNotSetException {
        if (this.serviceAccountConfig == null) {
            throw new KeyTypeNotSetException();
        }
        if (this.serviceAccountConfig.getAccountId() == null) {
            throw new AccountIdNotSetException();
        }
        if (this.serviceAccountConfig.getPrivateKey() == null) {
            throw new PrivateKeyNotSetException();
        }
        return new GoogleCredential.Builder().setTransport(this.getModule().getHttpTransport()).setJsonFactory(this.getModule().getJsonFactory()).setServiceAccountScopes(requirement.getScopes()).setServiceAccountId(this.serviceAccountConfig.getAccountId()).setServiceAccountPrivateKey(this.serviceAccountConfig.getPrivateKey()).build();
    }

    public ServiceAccountConfig getServiceAccountConfig() {
        return this.serviceAccountConfig;
    }

    public static class PrivateKeyNotSetException
    extends RuntimeException {
    }

    public static class AccountIdNotSetException
    extends RuntimeException {
    }

    public static class KeyTypeNotSetException
    extends RuntimeException {
    }

    public static class SecretsFileNotFoundException
    extends RuntimeException {
        public SecretsFileNotFoundException(Throwable cause) {
            super(cause);
        }
    }

    public static class InvalidSecretsFileException
    extends RuntimeException {
        public InvalidSecretsFileException() {
        }

        public InvalidSecretsFileException(Throwable cause) {
            super(cause);
        }
    }

    public static class MissingSecretsFileException
    extends RuntimeException {
    }

    @Extension
    public static class Descriptor
    extends AbstractGoogleRobotCredentialsDescriptor {
        public Descriptor() {
            this(new GoogleRobotCredentialsModule());
        }

        @VisibleForTesting
        Descriptor(GoogleRobotCredentialsModule module) {
            super(GoogleRobotPrivateKeyCredentials.class, module);
        }

        public String getDisplayName() {
            return Messages.GoogleRobotPrivateKeyCredentials_DisplayName();
        }
    }
}

