/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.credentials.oauth;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.jenkins.plugins.credentials.oauth.AbstractGoogleRobotCredentialsDescriptor;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2ScopeRequirement;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentialsModule;
import com.google.jenkins.plugins.credentials.oauth.Messages;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.joda.time.DateTime;

final class RemotableGoogleCredentials
extends GoogleRobotCredentials {
    private final String username;
    private final String accessToken;
    private final long expiration;
    private static final Long MINIMUM_DURATION_SECONDS = new Long(300L);

    public RemotableGoogleCredentials(GoogleRobotCredentials credentials, GoogleOAuth2ScopeRequirement requirement, GoogleRobotCredentialsModule module) throws GeneralSecurityException {
        super(((GoogleRobotCredentials)Preconditions.checkNotNull((Object)credentials)).getProjectId(), (GoogleRobotCredentialsModule)Preconditions.checkNotNull((Object)module));
        this.username = credentials.getUsername();
        Credential credential = credentials.getGoogleCredential((GoogleOAuth2ScopeRequirement)((Object)Preconditions.checkNotNull((Object)((Object)requirement))));
        try {
            Long rawExpiration = credential.getExpiresInSeconds();
            if (Ordering.natural().nullsFirst().compare((Object)rawExpiration, (Object)MINIMUM_DURATION_SECONDS) < 0 && !credential.refreshToken()) {
                throw new GeneralSecurityException(Messages.RemotableGoogleCredentials_NoAccessToken());
            }
        }
        catch (IOException e) {
            throw new GeneralSecurityException(Messages.RemotableGoogleCredentials_NoAccessToken(), e);
        }
        this.accessToken = (String)Preconditions.checkNotNull((Object)credential.getAccessToken());
        this.expiration = new DateTime().plusSeconds(((Long)Preconditions.checkNotNull((Object)credential.getExpiresInSeconds())).intValue()).getMillis();
    }

    public CredentialsScope getScope() {
        return CredentialsScope.GLOBAL;
    }

    @Override
    public AbstractGoogleRobotCredentialsDescriptor getDescriptor() {
        throw new UnsupportedOperationException(Messages.RemotableGoogleCredentials_BadGetDescriptor());
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public Credential getGoogleCredential(GoogleOAuth2ScopeRequirement requirement) throws GeneralSecurityException {
        long lifetimeSeconds = (this.expiration - new DateTime().getMillis()) / 1000L;
        return new GoogleCredential.Builder().setTransport(this.getModule().getHttpTransport()).setJsonFactory(this.getModule().getJsonFactory()).build().setAccessToken(this.accessToken).setExpiresInSeconds(Long.valueOf(lifetimeSeconds));
    }
}

