/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.util;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.jenkins.plugins.util.ExecutorException;
import com.google.jenkins.plugins.util.ForbiddenException;
import com.google.jenkins.plugins.util.NotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;

public interface MetadataReader {
    public boolean hasMetadata() throws IOException;

    public String readMetadata(String var1) throws IOException, ExecutorException;

    public static class Default
    implements MetadataReader {
        private final HttpRequestFactory requestFactory;
        public static final String METADATA_SERVER = "http://metadata/computeMetadata/v1";

        public Default() {
            this(new NetHttpTransport().createRequestFactory());
        }

        public Default(HttpRequestFactory requestFactory) {
            this.requestFactory = (HttpRequestFactory)Preconditions.checkNotNull((Object)requestFactory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String readMetadata(String metadataPath) throws IOException, ExecutorException {
            HttpResponse response;
            HttpRequest request = this.requestFactory.buildGetRequest(new GenericUrl(METADATA_SERVER + metadataPath));
            request.getHeaders().set("X-Google-Metadata-Request", (Object)true);
            try {
                response = request.execute();
            }
            catch (HttpResponseException e) {
                switch (e.getStatusCode()) {
                    case 401: 
                    case 403: {
                        throw new ForbiddenException(e);
                    }
                    case 404: {
                        throw new NotFoundException(e);
                    }
                }
                throw e;
            }
            try (InputStreamReader inChars = null;){
                inChars = new InputStreamReader((InputStream)Preconditions.checkNotNull((Object)response.getContent()), Charsets.UTF_8);
                StringWriter output = new StringWriter();
                CharStreams.copy((Readable)inChars, (Appendable)output);
                String string = output.toString();
                return string;
            }
        }

        @Override
        public boolean hasMetadata() {
            try {
                this.readMetadata("");
                return true;
            }
            catch (IOException e) {
                return false;
            }
            catch (ExecutorException e) {
                return false;
            }
        }
    }
}

