/*
 * Decompiled with CFR 0.152.
 */
package htmlpublisher.util;

import htmlpublisher.util.FileEntryQueue;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import jenkins.security.Roles;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class DirScanningQueueWriter
implements FilePath.FileCallable<FileEntryQueue.Statistic> {
    private final UUID queueKey;
    private final DirScanner dirScanner;
    private static final long serialVersionUID = 1L;

    public DirScanningQueueWriter(DirScanner dirScanner, UUID queueKey) {
        this.queueKey = queueKey;
        this.dirScanner = dirScanner;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }

    public FileEntryQueue.Statistic invoke(File f, VirtualChannel channel) throws IOException {
        FileEntryQueue queue = FileEntryQueue.getOrCreateQueue(this.queueKey);
        try {
            this.dirScanner.scan(f, (FileVisitor)new Visitor(queue));
        }
        catch (IOException e) {
            queue.shutdownNow();
            throw e;
        }
        queue.shutdown();
        return queue.getStatistic();
    }

    private static class Visitor
    extends FileVisitor {
        private FileEntryQueue queue;

        public Visitor(FileEntryQueue queue) {
            this.queue = queue;
        }

        public void visit(File file, String relativePath) {
            this.queue.add(file, relativePath);
        }
    }
}

