/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.service;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import hudson.ProxyConfiguration;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.thoughtslive.jenkins.plugins.jira.Site;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.login.SigningInterceptor;
import org.thoughtslive.jenkins.plugins.jira.service.JiraEndPoints;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class JiraService {
    private final Site jiraSite;
    private final JiraEndPoints jiraEndPoints;

    public JiraService(Site jiraSite) {
        ProxyConfiguration proxyConfiguration;
        this.jiraSite = jiraSite;
        ConnectionPool CONNECTION_POOL = new ConnectionPool(5, 60L, TimeUnit.SECONDS);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().connectTimeout((long)jiraSite.getTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)jiraSite.getReadTimeout(), TimeUnit.MILLISECONDS).connectionPool(CONNECTION_POOL).retryOnConnectionFailure(true).addInterceptor((Interceptor)new SigningInterceptor(jiraSite));
        if (Jenkins.getInstanceOrNull() != null && (proxyConfiguration = Jenkins.get().proxy) != null) {
            final InetSocketAddress proxyAddr = new InetSocketAddress(proxyConfiguration.name, proxyConfiguration.port);
            Authenticator proxyAuthenticator = (route, response) -> {
                String credential = Credentials.basic((String)proxyConfiguration.getUserName(), (String)proxyConfiguration.getPassword());
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            };
            ProxySelector proxySelector = new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    boolean isNoProxyHost = proxyConfiguration.getNoProxyHostPatterns().stream().anyMatch(p -> p.matcher(uri.getHost()).matches());
                    ArrayList<Proxy> proxyList = new ArrayList<Proxy>();
                    proxyList.add(isNoProxyHost ? Proxy.NO_PROXY : new Proxy(Proxy.Type.HTTP, proxyAddr));
                    return proxyList;
                }

                @Override
                public void connectFailed(URI uri, SocketAddress arg, IOException ex) {
                    throw new RuntimeException(ex);
                }
            };
            okHttpClientBuilder.proxySelector(proxySelector).proxyAuthenticator(proxyAuthenticator);
        }
        OkHttpClient httpClient = okHttpClientBuilder.build();
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JodaModule());
        this.jiraEndPoints = (JiraEndPoints)new Retrofit.Builder().baseUrl(this.jiraSite.getUrl().toString()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).client(httpClient).build().create(JiraEndPoints.class);
    }

    public ResponseData<Map<String, Object>> getServerInfo() {
        try {
            return Common.parseResponse(this.jiraEndPoints.getServerInfo().execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getComponent(String id) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getComponent(id).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> createComponent(Object component) {
        try {
            return Common.parseResponse(this.jiraEndPoints.createComponent(component).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Void> updateComponent(String id, Object component) {
        try {
            return Common.parseResponse(this.jiraEndPoints.updateComponent(id, component).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getComponentIssueCount(String id) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getComponentIssueCount(id).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getIssue(String issueIdOrKey) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getIssue(issueIdOrKey).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> createIssue(Object issue) {
        try {
            return Common.parseResponse(this.jiraEndPoints.createIssue(issue).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> updateIssue(String issueIdOrKey, Object issue, Map<String, String> queryParams) {
        try {
            return Common.parseResponse(this.jiraEndPoints.updateIssue(issueIdOrKey, issue, queryParams).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Void> assignIssue(String issueIdorKey, String userName) {
        try {
            HashMap input = Maps.newHashMap();
            input.put("name", userName);
            return Common.parseResponse(this.jiraEndPoints.assignIssue(issueIdorKey, input).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> createIssues(Object issues) {
        try {
            return Common.parseResponse(this.jiraEndPoints.createIssues(issues).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getComments(String issueIdorKey) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getComments(issueIdorKey).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> addComment(String issueIdorKey, Object input) {
        try {
            return Common.parseResponse(this.jiraEndPoints.addComment(issueIdorKey, input).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> updateComment(String issueIdorKey, String commentId, Object input) {
        try {
            return Common.parseResponse(this.jiraEndPoints.updateComment(issueIdorKey, commentId, input).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getComment(String issueIdorKey, String commentId) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getComment(issueIdorKey, commentId).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Void> notifyIssue(String issueIdorKey, Object notify) {
        try {
            return Common.parseResponse(this.jiraEndPoints.notifyIssue(issueIdorKey, notify).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getIssueTransitions(String issueIdorKey) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getTransitions(issueIdorKey).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Void> transitionIssue(String idOrKey, Object issue) {
        try {
            return Common.parseResponse(this.jiraEndPoints.transitionIssue(idOrKey, issue).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getIssueWatches(String issueIdorKey) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getIssueWatches(issueIdorKey).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Void> addIssueWatcher(String issueIdorKey, String userName) {
        try {
            return Common.parseResponse(this.jiraEndPoints.addIssueWatcher(issueIdorKey, userName).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> searchIssues(String jql, int startAt, int maxResults, Object fields) {
        try {
            ImmutableMap.Builder paramsMap = ImmutableMap.builder().put((Object)"jql", (Object)jql).put((Object)"startAt", (Object)startAt).put((Object)"maxResults", (Object)maxResults);
            if (fields != null) {
                paramsMap.put((Object)"fields", fields);
            }
            return Common.parseResponse(this.jiraEndPoints.searchIssues(paramsMap.build()).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getProjects() {
        try {
            return Common.parseResponse(this.jiraEndPoints.getProjects().execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getProject(String projectIdOrKey) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getProject(projectIdOrKey).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getProjectVersions(String projectIdOrKey) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getProjectVersions(projectIdOrKey).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getProjectComponents(String projectIdOrKey) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getProjectComponents(projectIdOrKey).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getProjectStatuses(String projectIdOrKey) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getProjectStatuses(projectIdOrKey).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getVersion(String id) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getVersion(id).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> createVersion(Object version) {
        try {
            return Common.parseResponse(this.jiraEndPoints.createVersion(version).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Void> updateVersion(String id, Object version) {
        try {
            return Common.parseResponse(this.jiraEndPoints.updateVersion(id, version).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getIssueLinkTypes() {
        try {
            return Common.parseResponse(this.jiraEndPoints.getIssueLinkTypes().execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getIssueLink(String id) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getIssueLink(id).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> deleteIssueLink(String id) {
        try {
            return Common.parseResponse(this.jiraEndPoints.deleteIssueLink(id).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Void> linkIssues(String name, String inwardIssueKey, String outwardIssueKey, String comment) {
        ImmutableMap linkComment = null;
        ImmutableMap issueLink = null;
        if (!Common.empty(comment)) {
            linkComment = ImmutableMap.builder().put((Object)"body", (Object)comment).build();
            issueLink = ImmutableMap.builder().put((Object)"type", (Object)ImmutableMap.builder().put((Object)"name", (Object)name).build()).put((Object)"comment", (Object)linkComment).put((Object)"inwardIssue", (Object)ImmutableMap.builder().put((Object)"key", (Object)inwardIssueKey).build()).put((Object)"outwardIssue", (Object)ImmutableMap.builder().put((Object)"key", (Object)outwardIssueKey).build()).build();
        } else {
            issueLink = ImmutableMap.builder().put((Object)"type", (Object)ImmutableMap.builder().put((Object)"name", (Object)name).build()).put((Object)"inwardIssue", (Object)ImmutableMap.builder().put((Object)"key", (Object)inwardIssueKey).build()).put((Object)"outwardIssue", (Object)ImmutableMap.builder().put((Object)"key", (Object)outwardIssueKey).build()).build();
        }
        try {
            return Common.parseResponse(this.jiraEndPoints.createIssueLink(issueLink).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getIssueRemoteLinks(String idOrKey, String globalId) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getIssueRemoteLinks(idOrKey, globalId).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getIssueRemoteLink(String idOrKey, String linkId) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getIssueRemoteLink(idOrKey, linkId).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> createIssueRemoteLink(String idOrKey, Object remoteLink) {
        try {
            return Common.parseResponse(this.jiraEndPoints.createIssueRemoteLink(idOrKey, remoteLink).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> deleteIssueRemoteLink(String idOrKey, String linkId) {
        try {
            return Common.parseResponse(this.jiraEndPoints.deleteIssueRemoteLink(idOrKey, linkId).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> deleteIssueRemoteLinks(String idOrKey, String globalId) {
        try {
            return Common.parseResponse(this.jiraEndPoints.deleteIssueRemoteLinks(idOrKey, globalId).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getFields() {
        try {
            return Common.parseResponse(this.jiraEndPoints.getFields().execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> userSearch(String userName, int startAt, int maxResults) {
        try {
            return Common.parseResponse(this.jiraEndPoints.userSearch(userName, startAt, maxResults).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> assignableUserSearch(String userName, String project, String issueKey, int startAt, int maxResults) {
        try {
            return Common.parseResponse(this.jiraEndPoints.assignableUserSearch(userName, project, issueKey, startAt, maxResults).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> uploadAttachment(String issueIdOrKey, String fileName, byte[] bytes) {
        try {
            RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (byte[])bytes);
            MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"file", (String)fileName, (RequestBody)requestFile);
            return Common.parseResponse(this.jiraEndPoints.uploadAttachment(issueIdOrKey, multipartBody).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> getAttachment(String attachmentId) {
        try {
            return Common.parseResponse(this.jiraEndPoints.getAttachment(attachmentId).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<Object> deleteAttachment(String attachmentId) {
        try {
            return Common.parseResponse(this.jiraEndPoints.deleteAttachment(attachmentId).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }

    public ResponseData<ResponseBody> downloadAttachment(String attachmentLink) {
        try {
            return Common.parseResponse(this.jiraEndPoints.downloadFileWithDynamicUrl(attachmentLink).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }
}

