/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import com.google.common.collect.ImmutableMap;
import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.thoughtslive.jenkins.plugins.jira.api.InputBuilder;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class AddCommentStep
extends BasicJiraStep {
    private static final long serialVersionUID = 8523118063993121080L;
    private final String idOrKey;
    @Deprecated
    private final String comment;
    @DataBoundSetter
    private Object input;

    @Deprecated
    @DataBoundConstructor
    public AddCommentStep(String idOrKey, String comment) {
        this.idOrKey = idOrKey;
        this.comment = comment;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getIdOrKey() {
        return this.idOrKey;
    }

    @Deprecated
    public String getComment() {
        return this.comment;
    }

    public Object getInput() {
        return this.input;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = 462945562138805176L;
        private final AddCommentStep step;

        protected Execution(AddCommentStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                if (this.step.getComment() != null) {
                    this.logger.println("JIRA: Site - " + this.siteName + " - Add new comment (deprecated): " + this.step.getComment() + " on issue: " + this.step.getIdOrKey());
                    String comment = this.step.isAuditLog() ? this.addPanelMeta(this.step.getComment()) : this.step.getComment();
                    response = this.jiraService.addComment(this.step.getIdOrKey(), ImmutableMap.builder().put((Object)"body", (Object)comment).build());
                } else {
                    this.logger.println("JIRA: Site - " + this.siteName + " - Add new comment: " + this.step.getInput() + " on issue: " + this.step.getIdOrKey());
                    String message = InputBuilder.getField(this.step.getInput(), "body") != null ? InputBuilder.getField(this.step.getInput(), "body") : "";
                    String comment = this.step.isAuditLog() ? this.addPanelMeta(message) : message;
                    InputBuilder.setField(this.step.getInput(), "body", comment);
                    response = this.jiraService.addComment(this.step.getIdOrKey(), this.step.getInput());
                }
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String idOrKey = Util.fixEmpty((String)this.step.getIdOrKey());
                if (this.step.getComment() != null && this.step.getInput() != null) {
                    errorMessage = "Use either comment or input.";
                }
                if (this.step.getComment() == null && this.step.getInput() == null) {
                    errorMessage = "You need to set at least comment or input.";
                }
                if (idOrKey == null) {
                    errorMessage = "idOrKey is empty or null.";
                }
                if (this.step.getComment() != null && this.step.getComment().isEmpty()) {
                    errorMessage = "comment is empty.";
                }
                if (this.step.getInput() != null && (InputBuilder.getField(this.step.getInput(), "body") == null || InputBuilder.getField(this.step.getInput(), "body").isEmpty())) {
                    errorMessage = "input body is empty or null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraAddComment";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Add Comment";
        }
    }
}

