/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class AddWatcherStep
extends BasicJiraStep {
    private static final long serialVersionUID = 6417829072320454268L;
    private final String idOrKey;
    private final String userName;

    @DataBoundConstructor
    public AddWatcherStep(String idOrKey, String userName) {
        this.idOrKey = idOrKey;
        this.userName = userName;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getIdOrKey() {
        return this.idOrKey;
    }

    public String getUserName() {
        return this.userName;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Void>> {
        private static final long serialVersionUID = 937198146137084269L;
        private final AddWatcherStep step;

        protected Execution(AddWatcherStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Void> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Adding " + this.step.getUserName() + " to issue: " + this.step.getIdOrKey() + " as a watcher.");
                response = this.jiraService.addIssueWatcher(this.step.getIdOrKey(), this.step.getUserName());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String idOrKey = Util.fixEmpty((String)this.step.getIdOrKey());
                String userName = Util.fixEmpty((String)this.step.getUserName());
                if (idOrKey == null) {
                    errorMessage = "idOrKey is empty or null.";
                }
                if (userName == null) {
                    errorMessage = "userName is empty or null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraAddWatcher";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Add Watcher";
        }
    }
}

