/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class DeleteIssueRemoteLinksStep
extends BasicJiraStep {
    private static final long serialVersionUID = 3529709240318435576L;
    private final String idOrKey;
    private final String globalId;

    @DataBoundConstructor
    public DeleteIssueRemoteLinksStep(String idOrKey, String globalId) {
        this.idOrKey = idOrKey;
        this.globalId = globalId;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getIdOrKey() {
        return this.idOrKey;
    }

    public String getGlobalId() {
        return this.globalId;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = 325576266548671174L;
        private final DeleteIssueRemoteLinksStep step;

        protected Execution(DeleteIssueRemoteLinksStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Deleting Issue's " + this.step.getIdOrKey() + " Remote links Link by globalId:" + this.step.getGlobalId());
                response = this.jiraService.deleteIssueRemoteLinks(this.step.getIdOrKey(), this.step.getGlobalId());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                if (Util.fixEmpty((String)this.step.getIdOrKey()) == null) {
                    errorMessage = "idOrKey is empty or null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraDeleteIssueRemoteLinks";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Delete Issue's Remote Links by globalId.";
        }
    }
}

