/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import com.google.common.collect.ImmutableMap;
import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.thoughtslive.jenkins.plugins.jira.api.InputBuilder;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class EditCommentStep
extends BasicJiraStep {
    private static final long serialVersionUID = -6330276534463853856L;
    private final String idOrKey;
    private final String commentId;
    @Deprecated
    private final String comment;
    @DataBoundSetter
    private Object input;

    @Deprecated
    @DataBoundConstructor
    public EditCommentStep(String idOrKey, String commentId, String comment) {
        this.idOrKey = idOrKey;
        this.commentId = commentId;
        this.comment = comment;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getIdOrKey() {
        return this.idOrKey;
    }

    public String getCommentId() {
        return this.commentId;
    }

    @Deprecated
    public String getComment() {
        return this.comment;
    }

    public Object getInput() {
        return this.input;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = -7000442485946132663L;
        private final EditCommentStep step;

        protected Execution(EditCommentStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                if (this.step.getComment() != null) {
                    this.logger.println("JIRA: Site - " + this.siteName + " - Updating comment (deprecated): " + this.step.getComment() + " on issue: " + this.step.getIdOrKey());
                    response = this.jiraService.updateComment(this.step.getIdOrKey(), this.step.getCommentId(), ImmutableMap.builder().put((Object)"body", (Object)this.step.getComment()).build());
                } else {
                    this.logger.println("JIRA: Site - " + this.siteName + " - Updating comment: " + this.step.getInput() + " on issue: " + this.step.getIdOrKey());
                    response = this.jiraService.updateComment(this.step.getIdOrKey(), this.step.getCommentId(), this.step.getInput());
                }
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String idOrKey = Util.fixEmpty((String)this.step.getIdOrKey());
                String commentId = Util.fixEmpty((String)this.step.getCommentId());
                if (this.step.getComment() != null && this.step.getInput() != null) {
                    errorMessage = "Use either comment or input.";
                }
                if (this.step.getComment() == null && this.step.getInput() == null) {
                    errorMessage = "You need to set at least comment or input.";
                }
                if (idOrKey == null) {
                    errorMessage = "idOrKey is empty or null.";
                }
                if (commentId == null) {
                    errorMessage = "commentId is empty or null.";
                }
                if (this.step.getComment() != null && this.step.getComment().isEmpty()) {
                    errorMessage = "comment is empty.";
                }
                if (this.step.getInput() != null && (InputBuilder.getField(this.step.getInput(), "body") == null || InputBuilder.getField(this.step.getInput(), "body").isEmpty())) {
                    errorMessage = "input body is empty or null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraEditComment";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Edit Issue Comment";
        }
    }
}

