/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class EditComponentStep
extends BasicJiraStep {
    private static final long serialVersionUID = 6528605492208170984L;
    private final String id;
    private final Object component;

    @DataBoundConstructor
    public EditComponentStep(String id, Object component) {
        this.id = id;
        this.component = component;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getId() {
        return this.id;
    }

    public Object getComponent() {
        return this.component;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Void>> {
        private static final long serialVersionUID = 6229925264184593843L;
        private final EditComponentStep step;

        protected Execution(EditComponentStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Void> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Updating component: " + this.step.getComponent());
                response = this.jiraService.updateComponent(this.step.getId(), this.step.getComponent());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String id = Util.fixEmpty((String)this.step.getId());
                if (id == null) {
                    errorMessage = "id is empty or null.";
                }
                if (this.step.getComponent() == null) {
                    errorMessage = "component is empty or null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraEditComponent";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Edit Component";
        }
    }
}

