/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class GetCommentStep
extends BasicJiraStep {
    private static final long serialVersionUID = -3225315653270733874L;
    private final String idOrKey;
    private final String commentId;

    @DataBoundConstructor
    public GetCommentStep(String idOrKey, String commentId) {
        this.commentId = commentId;
        this.idOrKey = idOrKey;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getIdOrKey() {
        return this.idOrKey;
    }

    public String getCommentId() {
        return this.commentId;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = 6956525377031302225L;
        private final GetCommentStep step;

        protected Execution(GetCommentStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Querying issue: " + this.step.getIdOrKey() + " comment with id: " + this.step.getCommentId());
                response = this.jiraService.getComment(this.step.getIdOrKey(), this.step.getCommentId());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String idOrKey = Util.fixEmpty((String)this.step.getIdOrKey());
                String commentId = Util.fixEmpty((String)this.step.getCommentId());
                if (idOrKey == null) {
                    errorMessage = "idOrKey is empty or null.";
                }
                if (commentId == null) {
                    errorMessage = "commentId is empty or null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraGetComment";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Get Issue Comment";
        }
    }
}

