/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class GetIssueRemoteLinkStep
extends BasicJiraStep {
    private static final long serialVersionUID = 3529709240318435576L;
    private final String idOrKey;
    private final String linkId;

    @DataBoundConstructor
    public GetIssueRemoteLinkStep(String idOrKey, String linkId) {
        this.idOrKey = idOrKey;
        this.linkId = linkId;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getIdOrKey() {
        return this.idOrKey;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = 325576266548671174L;
        private final GetIssueRemoteLinkStep step;

        protected Execution(GetIssueRemoteLinkStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Querying Issue's " + this.step.getIdOrKey() + " remote link by linkId:" + this.step.getLinkId());
                response = this.jiraService.getIssueRemoteLink(this.step.getIdOrKey(), this.step.getLinkId());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                if (Util.fixEmpty((String)this.step.getIdOrKey()) == null) {
                    errorMessage = "idOrKey is empty or null.";
                }
                if (Util.fixEmpty((String)this.step.getLinkId()) == null) {
                    errorMessage = "linkId is empty or null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraGetIssueRemoteLink";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Get Issue's Remote Link by linkId.";
        }
    }
}

