/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class GetProjectComponentsStep
extends BasicJiraStep {
    private static final long serialVersionUID = 1831738736953963099L;
    private final String idOrKey;

    @DataBoundConstructor
    public GetProjectComponentsStep(String idOrKey) {
        this.idOrKey = idOrKey;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getIdOrKey() {
        return this.idOrKey;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = -1946537791588473196L;
        private final GetProjectComponentsStep step;

        protected Execution(GetProjectComponentsStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Querying Project Components with idOrKey:" + this.step.getIdOrKey());
                response = this.jiraService.getProjectComponents(this.step.getIdOrKey());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String idOrKey = Util.fixEmpty((String)this.step.getIdOrKey());
                if (idOrKey == null) {
                    errorMessage = "idOrKey is empty or null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraGetProjectComponents";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Get Project Components";
        }
    }
}

