/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class GetVersionStep
extends BasicJiraStep {
    private static final long serialVersionUID = -4252560961571411897L;
    private final String id;

    @DataBoundConstructor
    public GetVersionStep(String id) {
        this.id = id;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getId() {
        return this.id;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = 325576266548671174L;
        private final GetVersionStep step;

        protected Execution(GetVersionStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Querying Project Version with id:" + this.step.getId());
                response = this.jiraService.getVersion(this.step.getId());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                if (Util.fixEmpty((String)this.step.getId()) == null) {
                    errorMessage = "id is empty or null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraGetVersion";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Get Version";
        }
    }
}

