/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class JqlSearchStep
extends BasicJiraStep {
    private static final long serialVersionUID = -7754102811625753132L;
    private final String jql;
    @DataBoundSetter
    private int startAt = 0;
    @DataBoundSetter
    private int maxResults = 1000;
    @DataBoundSetter
    private Object fields;

    @DataBoundConstructor
    public JqlSearchStep(String jql) {
        this.jql = jql;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getJql() {
        return this.jql;
    }

    public int getStartAt() {
        return this.startAt;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Object getFields() {
        return this.fields;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = 3640953129479843111L;
        private final JqlSearchStep step;

        protected Execution(JqlSearchStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Search JQL: " + this.step.getJql() + " startAt: " + this.step.getStartAt() + " maxResults: " + this.step.getMaxResults());
                response = this.jiraService.searchIssues(this.step.getJql(), this.step.getStartAt(), this.step.getMaxResults(), this.step.getFields());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String jql = Util.fixEmpty((String)this.step.getJql());
                if (jql == null) {
                    errorMessage = "jql is empty or null.";
                }
                if (this.step.getMaxResults() > 2000) {
                    errorMessage = "maxResults can't be more than 2000 to avoid memory issues.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraJqlSearch";
        }

        public String getDisplayName() {
            return this.getPrefix() + "JQL Search";
        }
    }
}

