/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class LinkIssuesStep
extends BasicJiraStep {
    private static final long serialVersionUID = -1881920733234295481L;
    private final String type;
    private final String inwardKey;
    private final String outwardKey;
    @DataBoundSetter
    private String comment;

    @DataBoundConstructor
    public LinkIssuesStep(String type, String inwardKey, String outwardKey) {
        this.type = type;
        this.inwardKey = inwardKey;
        this.outwardKey = outwardKey;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getType() {
        return this.type;
    }

    public String getInwardKey() {
        return this.inwardKey;
    }

    public String getOutwardKey() {
        return this.outwardKey;
    }

    public String getComment() {
        return this.comment;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Void>> {
        private static final long serialVersionUID = -1666683149182699538L;
        private final LinkIssuesStep step;

        protected Execution(LinkIssuesStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Void> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Linking issue(inward): " + this.step.getInwardKey() + " and issue(outward)" + this.step.getOutwardKey() + " with type: " + this.step.getType());
                response = this.jiraService.linkIssues(this.step.getType(), this.step.getInwardKey(), this.step.getOutwardKey(), this.step.getComment());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String type = Util.fixEmpty((String)this.step.getType());
                String inwardKey = Util.fixEmpty((String)this.step.getInwardKey());
                String outwardKey = Util.fixEmpty((String)this.step.getOutwardKey());
                if (type == null) {
                    errorMessage = "type is empty or null.";
                }
                if (inwardKey == null) {
                    errorMessage = "inwardKey is empty or null.";
                }
                if (outwardKey == null) {
                    errorMessage = "outwardKey is empty or null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraLinkIssues";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Link Issues";
        }
    }
}

