/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.InputBuilder;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class NewComponentStep
extends BasicJiraStep {
    private static final long serialVersionUID = 4939494003115851145L;
    private final Object component;

    @DataBoundConstructor
    public NewComponentStep(Object component) {
        this.component = component;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public Object getComponent() {
        return this.component;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = -6324419009842564119L;
        private final NewComponentStep step;

        protected Execution(NewComponentStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Creating new component: " + this.step.getComponent());
                if (this.step.isAuditLog()) {
                    String description = this.addMeta("");
                    InputBuilder.appendDescription(this.step.getComponent(), description);
                }
                response = this.jiraService.createComponent(this.step.getComponent());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            Object errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraNewComponent";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Create New Component";
        }
    }
}

