/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class TransitionIssueStep
extends BasicJiraStep {
    private static final long serialVersionUID = 5648167982018270684L;
    private final String idOrKey;
    private final Object input;

    @DataBoundConstructor
    public TransitionIssueStep(String idOrKey, Object input) {
        this.idOrKey = idOrKey;
        this.input = input;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getIdOrKey() {
        return this.idOrKey;
    }

    public Object getInput() {
        return this.input;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Void>> {
        private static final long serialVersionUID = 6038231959460139190L;
        private final TransitionIssueStep step;

        protected Execution(TransitionIssueStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Void> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Transition issue with idOrKey: " + this.step.getIdOrKey());
                response = this.jiraService.transitionIssue(this.step.getIdOrKey(), this.step.getInput());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String idOrKey = Util.fixEmpty((String)this.step.getIdOrKey());
                if (idOrKey == null) {
                    errorMessage = "idOrKey is empty or null.";
                }
                if (this.step.getInput() == null) {
                    errorMessage = "input is null.";
                    return Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraTransitionIssue";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Transition Issue";
        }
    }
}

