/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class UserSearchStep
extends BasicJiraStep {
    private static final long serialVersionUID = -7754102811625753132L;
    private final String queryStr;
    @DataBoundSetter
    private int startAt = 0;
    @DataBoundSetter
    private int maxResults = 1000;

    @DataBoundConstructor
    public UserSearchStep(String queryStr) {
        this.queryStr = queryStr;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getQueryStr() {
        return this.queryStr;
    }

    public int getStartAt() {
        return this.startAt;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = 3640953129479843111L;
        private final UserSearchStep step;

        protected Execution(UserSearchStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Searching JIRA Active Users: " + this.step.getQueryStr() + " startAt: " + this.step.getStartAt() + " maxResults: " + this.step.getMaxResults());
                response = this.jiraService.userSearch(this.step.getQueryStr(), this.step.getStartAt(), this.step.getMaxResults());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String queryStr = Util.fixEmpty((String)this.step.getQueryStr());
                if (queryStr == null) {
                    errorMessage = "queryStr is empty or null.";
                }
                if (this.step.getMaxResults() > 1000) {
                    errorMessage = "maxResults: The maximum allowed value is 1000.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraUserSearch";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Search Active JIRA Users by username, name or email address.";
        }
    }
}

