/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.util;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Util;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.thoughtslive.jenkins.plugins.jira.Messages;
import org.thoughtslive.jenkins.plugins.jira.Site;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.service.JiraService;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;

public abstract class JiraStepExecution<T>
extends SynchronousNonBlockingStepExecution<T> {
    private static final long serialVersionUID = 3856797875872780808L;
    public transient JiraService jiraService = null;
    protected transient PrintStream logger = null;
    protected transient String siteName = null;
    protected transient boolean failOnError = true;
    protected transient String buildUserId = null;
    protected transient String buildUrl = null;
    private transient Run<?, ?> run;
    private transient TaskListener listener;
    private transient EnvVars envVars;

    protected JiraStepExecution(StepContext context) throws IOException, InterruptedException {
        super(context);
        this.run = (Run)context.get(Run.class);
        this.listener = (TaskListener)context.get(TaskListener.class);
        this.envVars = (EnvVars)context.get(EnvVars.class);
    }

    protected static String prepareBuildUserId(List<Cause> causes) {
        String buildUser = "anonymous";
        if (causes != null && causes.size() > 0) {
            if (causes.get(0) instanceof Cause.UserIdCause) {
                buildUser = ((Cause.UserIdCause)causes.get(0)).getUserId();
            } else if (causes.get(0) instanceof Cause.UpstreamCause) {
                List upstreamCauses = ((Cause.UpstreamCause)causes.get(0)).getUpstreamCauses();
                buildUser = JiraStepExecution.prepareBuildUserId(upstreamCauses);
            }
        }
        return Util.fixEmpty((String)buildUser) == null ? "anonymous" : buildUser;
    }

    protected <T> ResponseData<T> verifyCommon(BasicJiraStep step) throws AbortException {
        this.logger = this.listener.getLogger();
        Object errorMessage = null;
        this.siteName = Common.empty(step.getSite()) ? (String)this.envVars.get((Object)"JIRA_SITE") : step.getSite();
        Site site = Site.get(this.siteName);
        String failOnErrorStr = Util.fixEmpty((String)((String)this.envVars.get((Object)"JIRA_FAIL_ON_ERROR")));
        this.failOnError = failOnErrorStr == null ? step.isFailOnError() : Boolean.parseBoolean(failOnErrorStr);
        if (Common.empty(this.siteName)) {
            errorMessage = "JIRA_SITE is empty or null.";
        }
        if (site == null) {
            errorMessage = "No JIRA site configured with " + this.siteName + " name.";
        } else if (this.jiraService == null) {
            StandardUsernameCredentials credentialsId;
            if (Site.LoginType.CREDENTIAL.name().equals(site.getLoginType()) && (credentialsId = (StandardUsernameCredentials)CredentialsProvider.findCredentialById((String)site.getCredentialsId(), StandardUsernameCredentials.class, this.run, Collections.emptyList())) == null) {
                throw new AbortException(Messages.Site_invalidCredentialsId());
            }
            this.jiraService = site.getService();
        }
        if (errorMessage != null) {
            return Common.buildErrorResponse(new RuntimeException((String)errorMessage));
        }
        this.buildUserId = JiraStepExecution.prepareBuildUserId(this.run.getCauses());
        this.buildUrl = (String)this.envVars.get((Object)"BUILD_URL");
        return null;
    }

    protected <T> ResponseData<T> logResponse(ResponseData<T> response) throws AbortException {
        if (response.isSuccessful()) {
            Common.log(this.logger, "Successful. Code: " + response.getCode());
        } else {
            Common.log(this.logger, "Error Code: " + response.getCode());
            Common.log(this.logger, "Error Message: " + response.getError());
            if (this.failOnError) {
                throw new AbortException(response.getError());
            }
        }
        return response;
    }

    protected String addPanelMeta(String message) {
        return message + "\n{panel}Automatically created by: [~" + this.buildUserId + "] from [Build URL|" + this.buildUrl + "]{panel}";
    }

    protected String addMeta(String message) {
        return message + "\nAutomatically created by: " + this.buildUserId + " from " + this.buildUrl;
    }

    protected abstract <T> ResponseData<T> verifyInput() throws Exception;
}

