/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MavenUtils {
    private static final Logger logger = LoggerFactory.getLogger(MavenUtils.class);
    private static final String UNKNOWN_VERSION = "unknown";

    MavenUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getVersion(String groupId, String artifactId) {
        Properties props = new Properties();
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(MavenUtils.getPomFilePath(groupId, artifactId));){
            props.load(is);
            String string = props.getProperty("version", UNKNOWN_VERSION);
            return string;
        }
        catch (Exception e) {
            logger.debug("Could not find version for maven artifact {}:{}", (Object)groupId, (Object)artifactId);
            logger.debug("Got the following exception:", (Throwable)e);
            return UNKNOWN_VERSION;
        }
    }

    private static String getPomFilePath(String groupId, String artifactId) {
        return String.format("META-INF/maven/%s/%s/pom.properties", groupId, artifactId);
    }
}

