/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.model.Action;
import hudson.model.Run;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.model.JiraIssue;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class JiraBuildAction
implements Action {
    public final Run<?, ?> owner;
    private Set<JiraIssue> issues;

    public JiraBuildAction(@Nonnull Run<?, ?> owner, @Nonnull Set<JiraIssue> issues) {
        this.owner = owner;
        this.issues = new HashSet<JiraIssue>(issues);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return Messages.JiraBuildAction_DisplayName();
    }

    public String getUrlName() {
        return "jira";
    }

    @Exported(inline=true)
    public Set<JiraIssue> getIssues() {
        return this.issues;
    }

    @Exported
    public String getServerURL() {
        JiraSite jiraSite = JiraSite.get(this.owner.getParent());
        URL url = jiraSite != null ? jiraSite.getUrl() : null;
        return url != null ? url.toString() : null;
    }

    public JiraIssue getIssue(String issueID) {
        for (JiraIssue issue : this.issues) {
            if (!issue.getKey().equals(issueID)) continue;
            return issue;
        }
        return null;
    }

    public void addIssues(Set<JiraIssue> issuesToBeSaved) {
        this.issues.addAll(issuesToBeSaved);
    }
}

