/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JiraFolderProperty
extends AbstractFolderProperty<AbstractFolder<?>> {
    private List<JiraSite> sites = Collections.emptyList();

    @DataBoundConstructor
    public JiraFolderProperty() {
    }

    public JiraSite[] getSites() {
        return this.sites.toArray(new JiraSite[0]);
    }

    @Deprecated
    public void setSites(JiraSite site) {
        this.sites.add(site);
    }

    @DataBoundSetter
    public void setSites(List<JiraSite> sites) {
        this.sites = sites;
    }

    public static List<JiraSite> getSitesFromFolders(ItemGroup itemGroup) {
        ArrayList<JiraSite> result = new ArrayList<JiraSite>();
        while (itemGroup instanceof AbstractFolder) {
            AbstractFolder folder = (AbstractFolder)itemGroup;
            JiraFolderProperty jiraFolderProperty = (JiraFolderProperty)folder.getProperties().get(JiraFolderProperty.class);
            if (jiraFolderProperty != null && jiraFolderProperty.getSites().length != 0) {
                result.addAll(Arrays.asList(jiraFolderProperty.getSites()));
            }
            itemGroup = folder.getParent();
        }
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        @Nonnull
        public String getDisplayName() {
            return Messages.JiraFolderProperty_DisplayName();
        }
    }
}

