/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import hudson.Extension;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.jira.JiraFolderProperty;
import hudson.plugins.jira.JiraGlobalConfiguration;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.util.ListBoxModel;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class JiraProjectProperty
extends JobProperty<Job<?, ?>> {
    public final String siteName;

    @DataBoundConstructor
    public JiraProjectProperty(String siteName) {
        List<JiraSite> sites;
        siteName = Util.fixEmptyAndTrim((String)siteName);
        if (siteName == null && !(sites = JiraGlobalConfiguration.get().getSites()).isEmpty()) {
            siteName = sites.get(0).getName();
        }
        this.siteName = siteName;
    }

    @Nullable
    public JiraSite getSite() {
        List<JiraSite> sites = JiraGlobalConfiguration.get().getSites();
        if (this.siteName == null && sites.size() > 0) {
            return sites.get(0);
        }
        Stream streams = sites.stream();
        if (this.owner != null) {
            Stream stream2 = JiraFolderProperty.getSitesFromFolders(this.owner.getParent()).stream();
            streams = (Stream)Stream.concat(streams, stream2).parallel();
        }
        return streams.filter(jiraSite -> jiraSite.getName().equals(this.siteName)).findFirst().orElse(null);
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        @Deprecated
        protected transient List<JiraSite> sites;

        public boolean isApplicable(Class<? extends Job> jobType) {
            return Job.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return Messages.JiraProjectProperty_DisplayName();
        }

        @Deprecated
        public void setSites(JiraSite site) {
            JiraGlobalConfiguration.get().getSites().add(site);
        }

        @Deprecated
        public JiraSite[] getSites() {
            return JiraGlobalConfiguration.get().getSites().toArray(new JiraSite[0]);
        }

        public ListBoxModel doFillSiteNameItems(@AncestorInPath AbstractFolder<?> folder) {
            ListBoxModel items = new ListBoxModel();
            for (JiraSite site : JiraGlobalConfiguration.get().getSites()) {
                items.add(site.getName());
            }
            if (folder != null) {
                List<JiraSite> sitesFromFolder = JiraFolderProperty.getSitesFromFolders(folder);
                sitesFromFolder.stream().map(JiraSite::getName).forEach(arg_0 -> ((ListBoxModel)items).add(arg_0));
            }
            return items;
        }

        @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
        public void migrate() {
            DescriptorImpl descriptor = (DescriptorImpl)Jenkins.getInstance().getDescriptor(JiraProjectProperty.class);
            if (descriptor != null) {
                descriptor.load();
            }
        }

        protected Object readResolve() {
            if (this.sites != null) {
                JiraGlobalConfiguration jiraGlobalConfiguration = (JiraGlobalConfiguration)Jenkins.getInstance().getDescriptorOrDie(JiraGlobalConfiguration.class);
                jiraGlobalConfiguration.load();
                jiraGlobalConfiguration.getSites().addAll(this.sites);
                jiraGlobalConfiguration.save();
                this.sites = null;
                DescriptorImpl oldDescriptor = (DescriptorImpl)Jenkins.getInstance().getDescriptor(JiraProjectProperty.class);
                if (oldDescriptor != null) {
                    oldDescriptor.save();
                }
            }
            return this;
        }
    }
}

