/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.VersionCreator;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class JiraVersionCreatorBuilder
extends Builder
implements SimpleBuildStep {
    private String jiraVersion;
    private String jiraProjectKey;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public JiraVersionCreatorBuilder(String jiraVersion, String jiraProjectKey) {
        this.jiraVersion = jiraVersion;
        this.jiraProjectKey = jiraProjectKey;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getJiraVersion() {
        return this.jiraVersion;
    }

    public void setJiraVersion(String jiraVersion) {
        this.jiraVersion = jiraVersion;
    }

    public String getJiraProjectKey() {
        return this.jiraProjectKey;
    }

    public void setJiraProjectKey(String jiraProjectKey) {
        this.jiraProjectKey = jiraProjectKey;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        new VersionCreator().perform(build.getParent(), this.jiraVersion, this.jiraProjectKey, build, listener);
    }

    public BuildStepDescriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            super(JiraVersionCreatorBuilder.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public JiraVersionCreatorBuilder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (JiraVersionCreatorBuilder)((Object)req.bindJSON(JiraVersionCreatorBuilder.class, formData));
        }

        public String getDisplayName() {
            return Messages.JiraVersionCreatorBuilder_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/jira/help-version-create.html";
        }
    }
}

