/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.model.BuildListener;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.extension.ExtendedVersion;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

class VersionCreator {
    private static final Logger LOGGER = Logger.getLogger(VersionCreator.class.getName());

    VersionCreator() {
    }

    protected boolean perform(Job<?, ?> project, String jiraVersion, String jiraProjectKey, Run<?, ?> build, TaskListener listener) {
        String realVersion = null;
        String realProjectKey = null;
        try {
            realVersion = build.getEnvironment(listener).expand(jiraVersion);
            realProjectKey = build.getEnvironment(listener).expand(jiraProjectKey);
            if (StringUtils.isEmpty((String)realVersion)) {
                throw new IllegalArgumentException("No version specified");
            }
            if (StringUtils.isEmpty((String)realProjectKey)) {
                throw new IllegalArgumentException("No project specified");
            }
            String finalRealVersion = realVersion;
            JiraSite site = this.getSiteForProject(project);
            Optional<ExtendedVersion> sameNamedVersion = site.getVersions(realProjectKey).stream().filter(version -> version.getName().equals(finalRealVersion) && version.isReleased()).findFirst();
            if (sameNamedVersion.isPresent()) {
                listener.getLogger().println(Messages.JiraVersionCreator_VersionExists(realVersion, realProjectKey));
            } else {
                listener.getLogger().println(Messages.JiraVersionCreator_CreatingVersion(realVersion, realProjectKey));
                this.addVersion(realVersion, realProjectKey, site.getSession());
            }
        }
        catch (Exception e) {
            e.printStackTrace(listener.fatalError("Unable to add version %s to Jira project %s", new Object[]{realVersion, realProjectKey, e}));
            if (listener instanceof BuildListener) {
                ((BuildListener)listener).finished(Result.FAILURE);
            }
            return false;
        }
        return true;
    }

    protected void addVersion(String version, String projectKey, JiraSession session) {
        if (session == null) {
            LOGGER.warning("Jira session could not be established");
            return;
        }
        session.addVersion(version, projectKey);
    }

    protected JiraSite getSiteForProject(Job<?, ?> project) {
        return JiraSite.get(project);
    }
}

