/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.model.BuildListener;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.extension.ExtendedVersion;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class VersionReleaser {
    private static final Logger LOGGER = Logger.getLogger(VersionReleaser.class.getName());

    protected boolean perform(Job<?, ?> project, String jiraProjectKey, String jiraRelease, String jiraDescription, Run<?, ?> run, TaskListener listener) {
        String realRelease = "NOT_SET";
        String realProjectKey = null;
        try {
            realProjectKey = run.getEnvironment(listener).expand(jiraProjectKey);
            realRelease = run.getEnvironment(listener).expand(jiraRelease);
            String realDescription = run.getEnvironment(listener).expand(jiraDescription);
            if (StringUtils.isEmpty((CharSequence)realRelease)) {
                throw new IllegalArgumentException("Release is Empty");
            }
            if (StringUtils.isEmpty((CharSequence)realProjectKey)) {
                throw new IllegalArgumentException("No project specified");
            }
            String finalRealRelease = realRelease;
            JiraSite site = this.getSiteForProject(project);
            Optional<ExtendedVersion> sameNamedVersion = site.getVersions(realProjectKey).stream().filter(version -> version.getName().equals(finalRealRelease) && version.isReleased()).findFirst();
            if (sameNamedVersion.isPresent()) {
                listener.getLogger().println(Messages.VersionReleaser_AlreadyReleased(realRelease, realProjectKey));
            } else {
                listener.getLogger().println(Messages.VersionReleaser_MarkingReleased(realRelease, realProjectKey));
                this.releaseVersion(realProjectKey, realRelease, realDescription, site.getSession());
            }
        }
        catch (Exception e) {
            listener.fatalError("Unable to release jira version %s/%s: %s", new Object[]{realRelease, realProjectKey, e});
            if (listener instanceof BuildListener) {
                ((BuildListener)listener).finished(Result.FAILURE);
            }
            return false;
        }
        return true;
    }

    protected void releaseVersion(String projectKey, String versionName, String versionDescription, JiraSession session) {
        if (session == null) {
            LOGGER.warning("Jira session could not be established");
            return;
        }
        List<ExtendedVersion> versions = session.getVersions(projectKey);
        Optional<ExtendedVersion> matchingVersion = versions.stream().filter(version -> version.getName().equals(versionName)).findFirst();
        if (matchingVersion.isPresent()) {
            ExtendedVersion version2 = matchingVersion.get();
            ExtendedVersion releaseVersion = new ExtendedVersion(version2.getSelf(), version2.getId(), version2.getName(), !StringUtils.isEmpty((CharSequence)versionDescription) ? versionDescription : version2.getDescription(), version2.isArchived(), true, version2.getStartDate(), new DateTime());
            session.releaseVersion(projectKey, releaseVersion);
        }
    }

    protected JiraSite getSiteForProject(Job<?, ?> project) {
        return JiraSite.get(project);
    }
}

