/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.model;

import com.atlassian.jira.rest.client.api.domain.Version;
import hudson.plugins.jira.extension.ExtendedVersion;
import java.util.Calendar;

public class JiraVersion
implements Comparable<JiraVersion> {
    private final String name;
    private String description;
    private Calendar startDate;
    private final Calendar releaseDate;
    private final boolean released;
    private final boolean archived;

    public JiraVersion(String name, Calendar releaseDate, boolean released, boolean archived) {
        this.name = name;
        this.releaseDate = releaseDate;
        this.released = released;
        this.archived = archived;
    }

    @Deprecated
    public JiraVersion(String name, Calendar startDate, Calendar releaseDate, boolean released, boolean archived) {
        this.name = name;
        this.startDate = startDate;
        this.releaseDate = releaseDate;
        this.released = released;
        this.archived = archived;
    }

    public JiraVersion(String name, String description, Calendar startDate, Calendar releaseDate, boolean released, boolean archived) {
        this.name = name;
        this.description = description;
        this.startDate = startDate;
        this.releaseDate = releaseDate;
        this.released = released;
        this.archived = archived;
    }

    public JiraVersion(Version version) {
        this(version.getName(), version.getReleaseDate() == null ? null : version.getReleaseDate().toGregorianCalendar(), version.isReleased(), version.isArchived());
    }

    public JiraVersion(ExtendedVersion version) {
        this(version.getName(), version.getDescription(), version.getStartDate() == null ? null : version.getStartDate().toGregorianCalendar(), version.getReleaseDate() == null ? null : version.getReleaseDate().toGregorianCalendar(), version.isReleased(), version.isArchived());
    }

    @Override
    public int compareTo(JiraVersion that) {
        int result = this.releaseDate.compareTo(that.releaseDate);
        if (result == 0) {
            return this.name.compareTo(that.name);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.archived ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.releaseDate == null ? 0 : this.releaseDate.hashCode());
        result = 31 * result + (this.released ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JiraVersion other = (JiraVersion)obj;
        if (this.archived != other.archived) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate)) {
            return false;
        }
        if (this.releaseDate == null ? other.releaseDate != null : !this.releaseDate.equals(other.releaseDate)) {
            return false;
        }
        return this.released == other.released;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public Calendar getReleaseDate() {
        return this.releaseDate;
    }

    public boolean isReleased() {
        return this.released;
    }

    public boolean isArchived() {
        return this.archived;
    }
}

