/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.apache.httpcomponents.CompletableFuturePromiseHttpPromiseAsyncClient;
import com.atlassian.httpclient.apache.httpcomponents.DefaultRequest;
import com.atlassian.httpclient.apache.httpcomponents.DefaultResponse;
import com.atlassian.httpclient.apache.httpcomponents.MavenUtils;
import com.atlassian.httpclient.apache.httpcomponents.PromiseHttpAsyncClient;
import com.atlassian.httpclient.apache.httpcomponents.RedirectStrategy;
import com.atlassian.httpclient.apache.httpcomponents.RequestEntityEffect;
import com.atlassian.httpclient.api.DefaultResponseTransformation;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponsePromises;
import com.atlassian.httpclient.api.ResponseTransformation;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.httpclient.base.event.HttpRequestCompletedEvent;
import com.atlassian.httpclient.base.event.HttpRequestFailedEvent;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import hudson.ProxyConfiguration;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import io.atlassian.util.concurrent.ThreadFactories;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.ManagedNHttpClientConnectionFactory;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NHttpConnectionFactory;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public final class ApacheAsyncHttpClient<C>
implements HttpClient,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Supplier<String> httpClientVersion = () -> MavenUtils.getVersion("com.atlassian.httpclient", "atlassian-httpclient-api");
    private final Function<Object, Void> eventConsumer;
    private final Supplier<String> applicationName;
    private final ThreadLocalContextManager<C> threadLocalContextManager;
    private final ExecutorService callbackExecutor;
    private final HttpClientOptions httpClientOptions;
    private final CloseableHttpAsyncClient nonCachingHttpClient;

    public ApacheAsyncHttpClient(EventPublisher eventConsumer, ApplicationProperties applicationProperties, ThreadLocalContextManager<C> threadLocalContextManager) {
        this(eventConsumer, applicationProperties, threadLocalContextManager, new HttpClientOptions());
    }

    public ApacheAsyncHttpClient(EventPublisher eventConsumer, ApplicationProperties applicationProperties, ThreadLocalContextManager<C> threadLocalContextManager, HttpClientOptions options) {
        this(new DefaultApplicationNameSupplier(applicationProperties), new EventConsumerFunction(eventConsumer), threadLocalContextManager, options);
    }

    public ApacheAsyncHttpClient(Supplier<String> applicationName, Function<Object, Void> eventConsumer, ThreadLocalContextManager<C> threadLocalContextManager, HttpClientOptions options) {
        this.eventConsumer = Objects.requireNonNull(eventConsumer);
        this.applicationName = Objects.requireNonNull(applicationName);
        this.threadLocalContextManager = Objects.requireNonNull(threadLocalContextManager);
        this.httpClientOptions = Objects.requireNonNull(options);
        try {
            HttpAsyncClientBuilder clientBuilder = this.createClientBuilder();
            this.nonCachingHttpClient = clientBuilder.build();
            this.callbackExecutor = options.getCallbackExecutor();
            this.nonCachingHttpClient.start();
        }
        catch (IOReactorException e) {
            throw new RuntimeException("Reactor " + options.getThreadPrefix() + "not set up correctly", e);
        }
    }

    private HttpAsyncClientBuilder createClientBuilder() throws IOReactorException {
        ProxyConfiguration proxyConfiguration;
        HttpClientOptions options = this.httpClientOptions;
        IOReactorConfig reactorConfig = IOReactorConfig.custom().setIoThreadCount(options.getIoThreadCount()).setSelectInterval(options.getIoSelectInterval()).setInterestOpQueued(true).build();
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(reactorConfig);
        ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

            public boolean handle(IOException e) {
                ApacheAsyncHttpClient.this.log.error("IO exception in reactor ", (Throwable)e);
                return false;
            }

            public boolean handle(RuntimeException e) {
                ApacheAsyncHttpClient.this.log.error("Fatal runtime error", (Throwable)e);
                return false;
            }
        });
        PoolingNHttpClientConnectionManager connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, (NHttpConnectionFactory)ManagedNHttpClientConnectionFactory.INSTANCE, this.getRegistry(options), (SchemePortResolver)DefaultSchemePortResolver.INSTANCE, (DnsResolver)SystemDefaultDnsResolver.INSTANCE, options.getConnectionPoolTimeToLive(), TimeUnit.MILLISECONDS){

            protected void finalize() throws Throwable {
                try {
                    this.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        connectionManager.setDefaultMaxPerRoute(options.getMaxConnectionsPerHost());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)options.getConnectionTimeout()).setConnectionRequestTimeout((int)options.getLeaseTimeout()).setCookieSpec(options.getIgnoreCookies() ? "ignoreCookies" : "default").setSocketTimeout((int)options.getSocketTimeout()).build();
        HttpAsyncClientBuilder clientBuilder = HttpAsyncClients.custom().setThreadFactory(ThreadFactories.namedThreadFactory((String)(options.getThreadPrefix() + "-io"), (ThreadFactories.Type)ThreadFactories.Type.DAEMON)).setDefaultIOReactorConfig(reactorConfig).setConnectionManager((NHttpClientConnectionManager)connectionManager).setRedirectStrategy((org.apache.http.client.RedirectStrategy)new RedirectStrategy()).setUserAgent(this.getUserAgent(options)).setDefaultRequestConfig(requestConfig);
        if (Jenkins.get() != null && (proxyConfiguration = Jenkins.getInstance().proxy) != null) {
            HttpHost proxy = new HttpHost(proxyConfiguration.name, proxyConfiguration.port);
            if (StringUtils.isNotBlank((String)proxyConfiguration.getUserName())) {
                clientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE);
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyConfiguration.name, proxyConfiguration.port), (Credentials)new UsernamePasswordCredentials(proxyConfiguration.getUserName(), proxyConfiguration.getPassword()));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            clientBuilder.setRoutePlanner((HttpRoutePlanner)new JenkinsProxyRoutePlanner(proxy, proxyConfiguration.getNoProxyHostPatterns()));
        }
        return clientBuilder;
    }

    private Registry<SchemeIOSessionStrategy> getRegistry(HttpClientOptions options) {
        try {
            TrustSelfSignedStrategy strategy = options.trustSelfSignedCertificates() ? new TrustSelfSignedStrategy() : null;
            SSLContext sslContext = new SSLContextBuilder().useTLS().loadTrustMaterial(null, (TrustStrategy)strategy).build();
            SSLIOSessionStrategy sslioSessionStrategy = new SSLIOSessionStrategy(sslContext, ApacheAsyncHttpClient.split(System.getProperty("https.protocols")), ApacheAsyncHttpClient.split(System.getProperty("https.cipherSuites")), options.trustSelfSignedCertificates() ? this.getSelfSignedVerifier() : SSLIOSessionStrategy.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            return RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)sslioSessionStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            return this.getFallbackRegistry(e);
        }
    }

    private X509HostnameVerifier getSelfSignedVerifier() {
        return new X509HostnameVerifier(){

            public void verify(String host, SSLSocket ssl) throws IOException {
                ApacheAsyncHttpClient.this.log.debug("Verification for certificates from {} disabled", (Object)host);
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
                ApacheAsyncHttpClient.this.log.debug("Verification for certificates from {} disabled", (Object)host);
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                ApacheAsyncHttpClient.this.log.debug("Verification for certificates from {} disabled", (Object)host);
            }

            public boolean verify(String host, SSLSession sslSession) {
                ApacheAsyncHttpClient.this.log.debug("Verification for certificates from {} disabled", (Object)host);
                return true;
            }
        };
    }

    private Registry<SchemeIOSessionStrategy> getFallbackRegistry(GeneralSecurityException e) {
        this.log.error("Error when creating scheme session strategy registry", (Throwable)e);
        return RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)SSLIOSessionStrategy.getDefaultStrategy()).build();
    }

    private String getUserAgent(HttpClientOptions options) {
        return String.format("Atlassian HttpClient %s / %s / %s", httpClientVersion.get(), this.applicationName.get(), options.getUserAgent());
    }

    public final ResponsePromise execute(Request request) {
        try {
            return this.doExecute(request);
        }
        catch (Throwable t) {
            return ResponsePromises.toResponsePromise((Promise)Promises.rejected((Throwable)t));
        }
    }

    private ResponsePromise doExecute(Request request) {
        this.httpClientOptions.getRequestPreparer().accept(request);
        long start = System.currentTimeMillis();
        String uri = request.getUri().toString();
        Request.Method method = request.getMethod();
        HttpGet op = switch (method) {
            case Request.Method.GET -> new HttpGet(uri);
            case Request.Method.POST -> new HttpPost(uri);
            case Request.Method.PUT -> new HttpPut(uri);
            case Request.Method.DELETE -> new HttpDelete(uri);
            case Request.Method.OPTIONS -> new HttpOptions(uri);
            case Request.Method.HEAD -> new HttpHead(uri);
            case Request.Method.TRACE -> new HttpTrace(uri);
            default -> throw new UnsupportedOperationException(method.toString());
        };
        if (request.hasEntity()) {
            new RequestEntityEffect(request).apply((HttpRequestBase)op);
        }
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            op.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        PromiseHttpAsyncClient asyncClient = this.getPromiseHttpAsyncClient(request);
        return ResponsePromises.toResponsePromise((Promise)asyncClient.execute((HttpUriRequest)op, (HttpContext)new BasicHttpContext()).fold(throwable -> {
            long requestDuration = System.currentTimeMillis() - start;
            this.publishEvent(request, requestDuration, (Throwable)throwable);
            throw new RuntimeException((Throwable)throwable);
        }, httpResponse -> {
            long requestDuration = System.currentTimeMillis() - start;
            this.publishEvent(request, requestDuration, httpResponse.getStatusLine().getStatusCode());
            try {
                return this.translate((HttpResponse)httpResponse);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private void publishEvent(Request request, long requestDuration, int statusCode) {
        if (HttpStatus.OK.code <= statusCode && statusCode < HttpStatus.MULTIPLE_CHOICES.code) {
            this.eventConsumer.apply(new HttpRequestCompletedEvent(request.getUri().toString(), request.getMethod().name(), statusCode, requestDuration, (Map<String, String>)request.getAttributes()));
        } else {
            this.eventConsumer.apply(new HttpRequestFailedEvent(request.getUri().toString(), request.getMethod().name(), statusCode, requestDuration, (Map<String, String>)request.getAttributes()));
        }
    }

    private void publishEvent(Request request, long requestDuration, Throwable ex) {
        this.eventConsumer.apply(new HttpRequestFailedEvent(request.getUri().toString(), request.getMethod().name(), ex.toString(), requestDuration, (Map<String, String>)request.getAttributes()));
    }

    private PromiseHttpAsyncClient getPromiseHttpAsyncClient(Request request) {
        CloseableHttpAsyncClient nonCachingHttpClient;
        this.log.trace("Creating new HttpAsyncClient");
        try {
            HttpAsyncClientBuilder clientBuilder = this.createClientBuilder();
            nonCachingHttpClient = clientBuilder.build();
            nonCachingHttpClient.start();
        }
        catch (IOReactorException e) {
            throw new RuntimeException("Reactor " + this.httpClientOptions.getThreadPrefix() + "not set up correctly", e);
        }
        return new CompletableFuturePromiseHttpPromiseAsyncClient<C>(nonCachingHttpClient, this.threadLocalContextManager, this.callbackExecutor);
    }

    private Response translate(HttpResponse httpResponse) throws IOException {
        Header[] httpHeaders;
        StatusLine status = httpResponse.getStatusLine();
        DefaultResponse.DefaultResponseBuilder responseBuilder = DefaultResponse.builder().setMaxEntitySize(this.httpClientOptions.getMaxEntitySize()).setStatusCode(status.getStatusCode()).setStatusText(status.getReasonPhrase());
        for (Header httpHeader : httpHeaders = httpResponse.getAllHeaders()) {
            responseBuilder.setHeader(httpHeader.getName(), httpHeader.getValue());
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            responseBuilder.setEntityStream(entity.getContent());
        }
        return (Response)responseBuilder.build();
    }

    public void destroy() throws Exception {
        try {
            this.callbackExecutor.shutdown();
        }
        catch (Exception e) {
            this.log.warn("skip fail to shutdown callbackExecutor:" + e.getMessage(), (Throwable)e);
        }
        try {
            this.nonCachingHttpClient.close();
        }
        catch (Exception e) {
            this.log.warn("skip fail to shutdown nonCachingHttpClient:" + e.getMessage(), (Throwable)e);
        }
    }

    public void flushCacheByUriPattern(Pattern urlPattern) {
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s.split(" *, *");
    }

    public Request.Builder newRequest() {
        return DefaultRequest.builder(this);
    }

    public Request.Builder newRequest(URI uri) {
        return DefaultRequest.builder(this).setUri(uri);
    }

    public Request.Builder newRequest(URI uri, String contentType, String entity) {
        return DefaultRequest.builder(this).setContentType(contentType).setEntity(entity).setUri(uri);
    }

    public Request.Builder newRequest(String uri) {
        return this.newRequest(URI.create(uri));
    }

    public Request.Builder newRequest(String uri, String contentType, String entity) {
        return this.newRequest(URI.create(uri), contentType, entity);
    }

    public <A> ResponseTransformation.Builder<A> transformation() {
        return DefaultResponseTransformation.builder();
    }

    private static final class DefaultApplicationNameSupplier
    implements Supplier<String> {
        private final ApplicationProperties applicationProperties;

        public DefaultApplicationNameSupplier(ApplicationProperties applicationProperties) {
            this.applicationProperties = Objects.requireNonNull(applicationProperties);
        }

        @Override
        public String get() {
            return String.format("%s-%s (%s)", this.applicationProperties.getDisplayName(), this.applicationProperties.getVersion(), this.applicationProperties.getBuildNumber());
        }
    }

    private static class EventConsumerFunction
    implements Function<Object, Void> {
        private final EventPublisher eventPublisher;

        public EventConsumerFunction(EventPublisher eventPublisher) {
            this.eventPublisher = eventPublisher;
        }

        @Override
        public Void apply(Object event) {
            if (this.eventPublisher != null) {
                this.eventPublisher.publish(event);
            }
            return null;
        }
    }

    private class JenkinsProxyRoutePlanner
    extends DefaultRoutePlanner {
        private final HttpHost proxy;
        private final List<Pattern> nonProxyHosts;

        public JenkinsProxyRoutePlanner(HttpHost proxy, List<Pattern> nonProxyHosts) {
            super(null);
            this.proxy = (HttpHost)Args.notNull((Object)proxy, (String)"Proxy host");
            this.nonProxyHosts = nonProxyHosts;
        }

        protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
            return this.bypassProxy(target.getHostName()) ? null : this.proxy;
        }

        private boolean bypassProxy(String host) {
            for (Pattern p : this.nonProxyHosts) {
                if (!p.matcher(host).matches()) continue;
                return true;
            }
            return false;
        }
    }

    private static final class NoOpThreadLocalContextManager<C>
    implements ThreadLocalContextManager<C> {
        private NoOpThreadLocalContextManager() {
        }

        public C getThreadLocalContext() {
            return null;
        }

        public void setThreadLocalContext(C context) {
        }

        public void clearThreadLocalContext() {
        }
    }
}

